// https://github.com/nodejs/node/blob/v6.10.2/test/parallel/test-querystring-maxKeys-non-finite.js

'use strict';
// This test was originally written to test a regression
// that was introduced by
// https://github.com/nodejs/node/pull/2288#issuecomment-179543894

const assert = require('assert');
const objectKeys = require('../src/object-keys');
const parse = require('..').parse;

/*
taken from express-js/body-parser
https://github.com/expressjs/body-parser/
blob/ed25264fb494cf0c8bc992b8257092cd4f694d5e/test/urlencoded.js#L636-L651
*/
function createManyParams(count) {
  var str = '';

  if (count === 0) {
    return str;
  }

  str += '0=0';

  for (var i = 1; i < count; i++) {
    var n = i.toString(36);
    str += '&' + n + '=' + n;
  }

  return str;
}

describe('test-querystring-maxKeys-non-finite', function() {
  const count = 10000;
  const originalMaxLength = 1000;
  const params = createManyParams(count);

  // thealphanerd
  // 27def4f introduced a change to parse that would cause Inifity
  // to be passed to String.prototype.split as an argument for limit
  // In this instance split will always return an empty array
  // this test confirms that the output of parse is the expected length
  // when passed Infinity as the argument for maxKeys
  const resultInfinity =
    parse(params, undefined, undefined, {maxKeys: Infinity});
  const resultNaN = parse(params, undefined, undefined, {maxKeys: NaN});
  const resultInfinityString = parse(params, undefined, undefined, {
    maxKeys: 'Infinity'
  });
  const resultNaNString = parse(params, undefined, undefined, {maxKeys: 'NaN'});

  it('Non Finite maxKeys should return the length of input', function() {
    assert.equal(objectKeys(resultInfinity).length, count);
    assert.equal(objectKeys(resultNaN).length, count);
  });

  it(
    'Strings maxKeys should return the maxLength defined by parses internals',
    function() {
      assert.equal(objectKeys(resultInfinityString).length, originalMaxLength);
      assert.equal(objectKeys(resultNaNString).length, originalMaxLength);
    },
  );
});
