import Quill from 'quill';
import type { CorrectBound, Props, QuillTableBetter, TableCellMap, TableColgroup, TableRow } from '../types';
import { TableCell } from '../formats/table';
import TablePropertiesForm from './table-properties-form';
interface Children {
    [propName: string]: {
        content: string;
        handler: () => void;
    };
}
declare class TableMenus {
    quill: Quill;
    table: HTMLElement | null;
    root: HTMLElement;
    prevList: HTMLUListElement | null;
    prevTooltip: HTMLDivElement | null;
    scroll: boolean;
    tableBetter: QuillTableBetter;
    tablePropertiesForm: TablePropertiesForm;
    constructor(quill: Quill, tableBetter?: QuillTableBetter);
    copyTable(): Promise<void>;
    createList(children: Children): HTMLUListElement;
    createMenu(left: string, right: string, isDropDown: boolean): HTMLDivElement;
    createMenus(): HTMLDivElement;
    deleteColumn(isKeyboard?: boolean): void;
    deleteRow(isKeyboard?: boolean): void;
    deleteTable(): void;
    destroyTablePropertiesForm(): void;
    getCellsOffset(computeBounds: CorrectBound, bounds: CorrectBound, leftColspan: number, rightColspan: number): number;
    getColsOffset(colgroup: TableColgroup, computeBounds: CorrectBound, bounds: CorrectBound): number;
    getCorrectBounds(table: HTMLElement): CorrectBound[];
    getCorrectTds(deleteTds: Element[], computeBounds: CorrectBound, leftTd: Element, rightTd: Element): {
        changeTds: [Element, number][];
        delTds: Element[];
    };
    getDiffOffset(map: TableCellMap, colspan?: number): number;
    getRefInfo(row: TableRow, right: number): {
        id: string;
        ref: TableCell;
    };
    getSelectedTdAttrs(td: HTMLElement): Props;
    getSelectedTdsAttrs(selectedTds: HTMLElement[]): Props;
    getSelectedTdsInfo(): {
        computeBounds: {
            left: number;
            right: number;
            top: number;
            bottom: number;
        };
        leftTd: Element;
        rightTd: Element;
    };
    getTableAlignment(table: HTMLTableElement): string;
    getTdsFromMap(map: TableCellMap): HTMLElement[];
    handleClick(e: MouseEvent): void;
    hideMenus(): void;
    insertColumn(td: HTMLTableColElement, offset: number): void;
    insertParagraph(offset: number): void;
    insertRow(td: HTMLTableColElement, offset: number): void;
    mergeCells(): void;
    setCellsMap(cell: TableCell, map: TableCellMap): void;
    showMenus(): void;
    splitCell(): void;
    toggleAttribute(list: HTMLUListElement, tooltip: HTMLDivElement): void;
    updateMenus(table?: HTMLElement): void;
    updateScroll(scroll: boolean): void;
    updateTable(table: HTMLElement): void;
}
export default TableMenus;
