import type { CorrectBound, Props, TableCellChildren } from '../types';
import { TableCell, TableCellBlock } from '../formats/table';
import { ListContainer } from '../formats/list';
import TableHeader from '../formats/header';
declare function addDimensionsUnit(value: string): string;
declare function convertUnitToInteger(withUnit: string): string;
declare function createTooltip(content: string): HTMLDivElement;
declare function debounce(cb: Function, delay: number): () => void;
declare function filterWordStyle(s: string): string;
declare function getAlign(cellBlot: TableCell): string;
declare function getCellChildBlot(cellBlot: TableCell): TableCellBlock | TableHeader | ListContainer;
declare function getCellFormats(cellBlot: TableCell): [Props, string];
declare function getCellId(formats: string | Props): string;
declare function getClosestElement(element: HTMLElement, selector: string): Element;
declare function getComputeBounds(startCorrectBounds: CorrectBound, endCorrectBounds: CorrectBound): {
    left: number;
    right: number;
    top: number;
    bottom: number;
};
declare function getComputeSelectedCols(computeBounds: CorrectBound, table: Element, container: Element): Element[];
declare function getComputeSelectedTds(computeBounds: CorrectBound, table: Element, container: Element, type?: string): Element[];
declare function getCopyTd(html: string): string;
declare function getCorrectBounds(target: Element, container: Element): {
    left: number;
    top: number;
    width: number;
    height: number;
    right: number;
    bottom: number;
};
declare function getCorrectCellBlot(blot: TableCell | TableCellChildren): TableCell | null;
declare function getElementStyle(node: HTMLElement, rules: string[]): Props;
declare function isDimensions(key: string): boolean;
declare function isValidColor(color: string): boolean;
declare function isValidDimensions(value: string): boolean;
declare function removeElementProperty(node: HTMLElement, properties: string[]): void;
declare function rgbToHex(value: string): string;
declare function rgbaToHex(value: string): string;
declare function setElementAttribute(node: Element, attributes: Props): void;
declare function setElementProperty(node: HTMLElement, properties: Props): void;
declare function throttle(cb: Function, delay: number): () => void;
declare function throttleStrong(cb: Function, delay: number): () => void;
declare function updateTableWidth(table: HTMLElement, tableBounds: CorrectBound, change: number): void;
export { addDimensionsUnit, convertUnitToInteger, createTooltip, debounce, filterWordStyle, getAlign, getCellChildBlot, getCellFormats, getCellId, getClosestElement, getComputeBounds, getComputeSelectedCols, getComputeSelectedTds, getCopyTd, getCorrectBounds, getCorrectCellBlot, getElementStyle, isDimensions, isValidColor, isValidDimensions, removeElementProperty, rgbToHex, rgbaToHex, setElementAttribute, setElementProperty, throttle, throttleStrong, updateTableWidth };
