"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authenticated = void 0;
var React = __importStar(require("react"));
var useAuthenticated_1 = require("./useAuthenticated");
/**
 * Restrict access to children to authenticated users.
 * Redirects anonymous users to the login page.
 *
 * Use it to decorate your custom page components to require
 * authentication.
 *
 * @see useAuthState
 *
 * @example
 * import { Admin, CustomRoutes, Authenticated } from 'react-admin';
 *
 * const customRoutes = [
 *     <Route
 *         path="/foo"
 *         element={
 *             <Authenticated authParams={{ foo: 'bar' }}>
 *                 <Foo />
 *             </Authenticated>
 *         }
 *     />
 * ];
 * const App = () => (
 *     <Admin>
 *         <CustomRoutes>{customRoutes}</CustomRoutes>
 *     </Admin>
 * );
 */
var Authenticated = function (props) {
    var authParams = props.authParams, _a = props.loading, loading = _a === void 0 ? null : _a, children = props.children;
    // this hook will redirect to login if the user is not authenticated
    var isPending = (0, useAuthenticated_1.useAuthenticated)({ params: authParams }).isPending;
    if (isPending) {
        return loading;
    }
    return React.createElement(React.Fragment, null, children);
};
exports.Authenticated = Authenticated;
//# sourceMappingURL=Authenticated.js.map