"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogoutOnMount = void 0;
var react_1 = require("react");
var useLogout_1 = __importDefault(require("./useLogout"));
/**
 * Log the user out and redirect them to login.
 *
 * To be used as a catch-all route for anonymous users in a secure app.
 *
 * @see CoreAdminRoutes
 */
var LogoutOnMount = function () {
    var logout = (0, useLogout_1.default)();
    (0, react_1.useEffect)(function () {
        logout();
    }, [logout]);
    return null;
};
exports.LogoutOnMount = LogoutOnMount;
//# sourceMappingURL=LogoutOnMount.js.map