"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var react_1 = require("react");
var warning_1 = __importDefault(require("../util/warning"));
var useAuthenticated_1 = require("./useAuthenticated");
var usePermissions_1 = __importDefault(require("./usePermissions"));
var isEmptyChildren = function (children) { return react_1.Children.count(children) === 0; };
/**
 * After checking that the user is authenticated,
 * retrieves the user's permissions for a specific context.
 *
 * Useful for Route components ; used internally by Resource.
 * Use it to decorate your custom page components to require
 * a custom role. It will pass the permissions as a prop to your
 * component.
 *
 * You can set additional `authParams` at will if your authProvider
 * requires it.
 *
 * @example
 *     import { Admin, CustomRoutes, WithPermissions } from 'react-admin';
 *
 *     const Foo = ({ permissions }) => (
 *         {permissions === 'admin' ? <p>Sensitive data</p> : null}
 *         <p>Not sensitive data</p>
 *     );
 *
 *     const customRoutes = [
 *         <Route path="/foo" element={
 *             <WithPermissions
 *                  authParams={{ foo: 'bar' }}
 *                  component={({ permissions, ...props }) => <Foo permissions={permissions} {...props} />}
 *              />
 *         } />
 *     ];
 *     const App = () => (
 *         <Admin>
 *             <CustomRoutes>{customRoutes}</CustomRoutes>
 *         </Admin>
 *     );
 */
var WithPermissions = function (props) {
    var authParams = props.authParams, children = props.children, render = props.render, component = props.component, _a = props.loading, Loading = _a === void 0 ? null : _a, staticContext = props.staticContext, rest = __rest(props, ["authParams", "children", "render", "component", "loading", "staticContext"]);
    (0, warning_1.default)((render && children && !isEmptyChildren(children)) ||
        (render && component) ||
        (component && children && !isEmptyChildren(children)), 'You should only use one of the `component`, `render` and `children` props in <WithPermissions>');
    var isAuthenticationPending = (0, useAuthenticated_1.useAuthenticated)(authParams).isPending;
    var _b = (0, usePermissions_1.default)(authParams, {
        enabled: !isAuthenticationPending,
    }), permissions = _b.permissions, isPendingPermissions = _b.isPending;
    // We must check both pending states here as if the authProvider does not implement getPermissions, isPendingPermissions will always be false
    if (isAuthenticationPending || isPendingPermissions) {
        return Loading ? React.createElement(Loading, null) : null;
    }
    if (component) {
        return (0, react_1.createElement)(component, __assign({ permissions: permissions }, rest));
    }
    // @deprecated
    if (render) {
        return render(__assign({ permissions: permissions }, rest));
    }
    // @deprecated
    if (children) {
        return children(__assign({ permissions: permissions }, rest));
    }
};
exports.default = WithPermissions;
//# sourceMappingURL=WithPermissions.js.map