"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useCanAccessResources = void 0;
var react_1 = require("react");
var react_query_1 = require("@tanstack/react-query");
var useAuthProvider_1 = __importDefault(require("./useAuthProvider"));
var controller_1 = require("../controller");
/**
 * Checks whether users can access the provided resources.
 *
 * `useCanAccessResources` returns an object describing the state of the request:
 *
 * - start: { isPending: true }
 * - success: { canAccess: Object<string, boolean>, isPending: false }
 * - error: { error: [error from provider], isPending: false }
 *
 * @param {Object} params Any params you want to pass to the authProvider
 * @param {string} params.action The action to check access for
 * @param {string[]} params.resources The list of resources to check access for
 * @param {Object} params.record Optional. The record to check access for
 *
 * @returns Return the react-query result and a canAccess property which is a map of the resources and their access status { [resource: string]: boolean }
 *
 * @example
 * import { useCanAccessResources } from 'react-admin';
 *
 * const UserList = ({ record }) => {
 *     const { isPending, canAccess } = useCanAccessResources({
 *         action: 'read',
 *         resources: ['users.id', 'users.name', 'users.email'],
 *         record
 *     });
 *
 *     if (isPending) {
 *         return null;
 *     }
 *     return (
 *         <SimpleList
 *              primaryText={record => canAccess.users.name ? record.name : ''}
 *              secondaryText={record => canAccess.users.email ? record.email : ''}
 *              tertiaryText={record => canAccess.users.id ? record.id : ''}
 *          />
 *     );
 * };
 */
var useCanAccessResources = function (params) {
    var authProvider = (0, useAuthProvider_1.default)();
    var record = (0, controller_1.useRecordContext)(params);
    var action = params.action, resources = params.resources;
    var queryResult = (0, react_query_1.useQueries)({
        queries: resources.map(function (resource) {
            return {
                queryKey: ['auth', 'canAccess', resource, action, record],
                queryFn: function (_a) {
                    var signal = _a.signal;
                    return __awaiter(void 0, void 0, void 0, function () {
                        var canAccess;
                        return __generator(this, function (_b) {
                            switch (_b.label) {
                                case 0:
                                    if (!authProvider || !authProvider.canAccess) {
                                        return [2 /*return*/, { canAccess: true, resource: resource }];
                                    }
                                    return [4 /*yield*/, authProvider.canAccess({
                                            resource: resource,
                                            action: action,
                                            record: record,
                                            signal: authProvider.supportAbortSignal
                                                ? signal
                                                : undefined,
                                        })];
                                case 1:
                                    canAccess = _b.sent();
                                    return [2 /*return*/, { canAccess: canAccess, resource: resource }];
                            }
                        });
                    });
                },
            };
        }),
        combine: (combineSourceAccessResults),
    });
    var result = (0, react_1.useMemo)(function () {
        return __assign({ canAccess: queryResult.data }, queryResult);
    }, [queryResult]);
    var resultWithoutAuthProvider = (0, react_1.useMemo)(function () {
        return {
            canAccess: resources.reduce(function (acc, resource) {
                acc[resource] = true;
                return acc;
            }, {}),
            isPending: false,
            isError: false,
            error: null,
        };
    }, [resources]);
    return !authProvider || !authProvider.canAccess
        ? resultWithoutAuthProvider
        : result;
};
exports.useCanAccessResources = useCanAccessResources;
var combineSourceAccessResults = function (results) {
    var _a;
    return {
        data: results
            ? results.reduce(function (acc, _a) {
                var _b;
                var data = _a.data;
                if (!data) {
                    return acc;
                }
                var resource = data.resource, canAccess = data.canAccess;
                return __assign(__assign({}, acc), (_b = {}, _b[resource] = canAccess, _b));
            }, {})
            : undefined,
        isPending: results.some(function (result) { return result.isPending; }),
        isError: results.some(function (result) { return result.isError; }),
        error: ((_a = results.find(function (result) { return result.error; })) === null || _a === void 0 ? void 0 : _a.error) || undefined,
    };
};
//# sourceMappingURL=useCanAccessResources.js.map