"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useAuthProvider_1 = __importDefault(require("./useAuthProvider"));
/**
 * Get a callback for calling the authProvider.getPermissions() method.
 *
 * @see useAuthProvider
 *
 * @returns {Function} getPermissions callback
 *
 * This is a low level hook. See those more specialized hooks
 * offering state handling.
 *
 * @see usePermissions
 *
 * @example
 *
 * import { useGetPermissions } from 'react-admin';
 *
 * const Roles = () => {
 *     const [permissions, setPermissions] = useState([]);
 *     const getPermissions = useGetPermissions();
 *     useEffect(() => {
 *         getPermissions().then(permissions => setPermissions(permissions))
 *     }, [])
 *     return (
 *         <ul>
 *             {permissions.map((permission, key) => (
 *                 <li key={key}>{permission}</li>
 *             ))}
 *         </ul>
 *     );
 * }
 */
var useGetPermissions = function () {
    var authProvider = (0, useAuthProvider_1.default)();
    var getPermissions = (0, react_1.useCallback)(function (params) {
        if (params === void 0) { params = {}; }
        // react-query requires the query to return something
        if (authProvider && authProvider.getPermissions) {
            return authProvider
                .getPermissions(params)
                .then(function (result) { return result !== null && result !== void 0 ? result : null; });
        }
        return Promise.resolve([]);
    }, [authProvider]);
    return getPermissions;
};
exports.default = useGetPermissions;
//# sourceMappingURL=useGetPermissions.js.map