import { UseQueryOptions } from '@tanstack/react-query';
import { AuthRedirectResult } from '../types';
/**
 * This hook calls the `authProvider.handleCallback()` method on mount. This is meant to be used in a route called
 * by an external authentication service (e.g. Auth0) after the user has logged in.
 * By default, it redirects to application home page upon success, or to the `redirectTo` location returned by `authProvider. handleCallback`.
 *
 * @returns An object containing { isPending, data, error, refetch }.
 */
export declare const useHandleAuthCallback: (options?: UseHandleAuthCallbackOptions) => import("@tanstack/react-query/build/legacy/types").UseQueryResult<void | AuthRedirectResult, Error>;
/**
 * Key used to store the previous location in localStorage.
 * Used by the useHandleAuthCallback hook to redirect the user to their previous location after a successful login.
 */
export declare const PreviousLocationStorageKey = "@react-admin/nextPathname";
export type UseHandleAuthCallbackOptions = Omit<UseQueryOptions<AuthRedirectResult | void>, 'queryKey' | 'queryFn'> & {
    onSuccess?: (data: AuthRedirectResult | void) => void;
    onError?: (err: Error) => void;
    onSettled?: (data?: AuthRedirectResult | void, error?: Error | null) => void;
};
//# sourceMappingURL=useHandleAuthCallback.d.ts.map