"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreviousLocationStorageKey = exports.useHandleAuthCallback = void 0;
var react_1 = require("react");
var react_query_1 = require("@tanstack/react-query");
var react_router_1 = require("react-router");
var routing_1 = require("../routing");
var useAuthProvider_1 = __importDefault(require("./useAuthProvider"));
var util_1 = require("../util");
/**
 * This hook calls the `authProvider.handleCallback()` method on mount. This is meant to be used in a route called
 * by an external authentication service (e.g. Auth0) after the user has logged in.
 * By default, it redirects to application home page upon success, or to the `redirectTo` location returned by `authProvider. handleCallback`.
 *
 * @returns An object containing { isPending, data, error, refetch }.
 */
var useHandleAuthCallback = function (options) {
    var authProvider = (0, useAuthProvider_1.default)();
    var redirect = (0, routing_1.useRedirect)();
    var location = (0, react_router_1.useLocation)();
    var locationState = location.state;
    var nextPathName = locationState && locationState.nextPathname;
    var nextSearch = locationState && locationState.nextSearch;
    var defaultRedirectUrl = nextPathName ? nextPathName + nextSearch : '/';
    var _a = options !== null && options !== void 0 ? options : {}, onSuccess = _a.onSuccess, onError = _a.onError, onSettled = _a.onSettled, queryOptions = __rest(_a, ["onSuccess", "onError", "onSettled"]);
    var queryResult = (0, react_query_1.useQuery)(__assign({ queryKey: ['auth', 'handleCallback'], queryFn: function (_a) {
            var signal = _a.signal;
            return authProvider && typeof authProvider.handleCallback === 'function'
                ? authProvider
                    .handleCallback({ signal: signal })
                    .then(function (result) { return result !== null && result !== void 0 ? result : null; })
                : Promise.resolve();
        }, retry: false }, queryOptions));
    var onSuccessEvent = (0, util_1.useEvent)(onSuccess !== null && onSuccess !== void 0 ? onSuccess : (function (data) {
        var _a;
        // AuthProviders relying on a third party services redirect back to the app can't
        // use the location state to store the path on which the user was before the login.
        // So we support a fallback on the localStorage.
        var previousLocation = localStorage.getItem(exports.PreviousLocationStorageKey);
        var redirectTo = (_a = data === null || data === void 0 ? void 0 : data.redirectTo) !== null && _a !== void 0 ? _a : previousLocation;
        if (redirectTo === false) {
            return;
        }
        redirect(redirectTo !== null && redirectTo !== void 0 ? redirectTo : defaultRedirectUrl);
    }));
    var onErrorEvent = (0, util_1.useEvent)(onError !== null && onError !== void 0 ? onError : noop);
    var onSettledEvent = (0, util_1.useEvent)(onSettled !== null && onSettled !== void 0 ? onSettled : noop);
    (0, react_1.useEffect)(function () {
        if (queryResult.error == null || queryResult.isFetching)
            return;
        onErrorEvent(queryResult.error);
    }, [onErrorEvent, queryResult.error, queryResult.isFetching]);
    (0, react_1.useEffect)(function () {
        if (queryResult.data === undefined || queryResult.isFetching)
            return;
        onSuccessEvent(queryResult.data);
    }, [onSuccessEvent, queryResult.data, queryResult.isFetching]);
    (0, react_1.useEffect)(function () {
        if (queryResult.status === 'pending' || queryResult.isFetching)
            return;
        onSettledEvent(queryResult.data, queryResult.error);
    }, [
        onSettledEvent,
        queryResult.data,
        queryResult.error,
        queryResult.status,
        queryResult.isFetching,
    ]);
    return queryResult;
};
exports.useHandleAuthCallback = useHandleAuthCallback;
/**
 * Key used to store the previous location in localStorage.
 * Used by the useHandleAuthCallback hook to redirect the user to their previous location after a successful login.
 */
exports.PreviousLocationStorageKey = '@react-admin/nextPathname';
var noop = function () { };
//# sourceMappingURL=useHandleAuthCallback.js.map