import { HintedString } from '../types';
/**
 * A hook that returns true if the authProvider is currently checking the authentication status or the user's access rights.
 * @param params
 * @param params.action The action to check access for
 * @param params.resource The resource to check access for (optional). Defaults to the resource of the current ResourceContext.
 * @returns {boolean} true if the authProvider is currently checking the authentication status or the user's access rights, false otherwise.
 */
export declare const useIsAuthPending: (params: UseIsAuthPendingParams) => boolean;
export type UseIsAuthPendingParams = {
    resource?: string;
    action: HintedString<'list' | 'create' | 'edit' | 'show' | 'delete'>;
};
//# sourceMappingURL=useIsAuthPending.d.ts.map