"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var react_query_1 = require("@tanstack/react-query");
var useAuthProvider_1 = __importDefault(require("./useAuthProvider"));
var useLogoutIfAccessDenied_1 = __importDefault(require("./useLogoutIfAccessDenied"));
var util_1 = require("../util");
var emptyParams = {};
/**
 * Hook for getting user permissions
 *
 * Calls the authProvider.getPermissions() method using react-query.
 * If the authProvider returns a rejected promise, returns empty permissions.
 *
 * The return value updates according to the request state:
 *
 * - start: { isPending: true }
 * - success: { permissions: [any], isPending: false }
 * - error: { error: [error from provider], isPending: false }
 *
 * Useful to enable features based on user permissions
 *
 * @param {Object} params Any params you want to pass to the authProvider
 *
 * @returns The current auth check state. Destructure as { permissions, error, isPending, refetch }.
 *
 * @example
 *     import { usePermissions } from 'react-admin';
 *
 *     const PostDetail = () => {
 *         const { isPending, permissions } = usePermissions();
 *         if (!isPending && permissions == 'editor') {
 *             return <PostEdit />
 *         } else {
 *             return <PostShow />
 *         }
 *     };
 */
var usePermissions = function (params, queryParams) {
    if (params === void 0) { params = emptyParams; }
    if (queryParams === void 0) { queryParams = {
        staleTime: 5 * 60 * 1000,
    }; }
    var authProvider = (0, useAuthProvider_1.default)();
    var logoutIfAccessDenied = (0, useLogoutIfAccessDenied_1.default)();
    var _a = queryParams !== null && queryParams !== void 0 ? queryParams : {}, onSuccess = _a.onSuccess, onError = _a.onError, onSettled = _a.onSettled, queryOptions = __rest(_a, ["onSuccess", "onError", "onSettled"]);
    var queryResult = (0, react_query_1.useQuery)(__assign({ queryKey: ['auth', 'getPermissions', params], queryFn: function (_a) {
            var signal = _a.signal;
            return __awaiter(void 0, void 0, void 0, function () {
                var permissions;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            if (!authProvider || !authProvider.getPermissions) {
                                return [2 /*return*/, []];
                            }
                            return [4 /*yield*/, authProvider.getPermissions(__assign(__assign({}, params), { signal: signal }))];
                        case 1:
                            permissions = _b.sent();
                            return [2 /*return*/, permissions !== null && permissions !== void 0 ? permissions : null];
                    }
                });
            });
        } }, queryOptions));
    var onSuccessEvent = (0, util_1.useEvent)(onSuccess !== null && onSuccess !== void 0 ? onSuccess : noop);
    var onSettledEvent = (0, util_1.useEvent)(onSettled !== null && onSettled !== void 0 ? onSettled : noop);
    var onErrorEvent = (0, util_1.useEvent)(onError !== null && onError !== void 0 ? onError : (function (error) {
        if (process.env.NODE_ENV === 'development') {
            console.error(error);
        }
        logoutIfAccessDenied(error);
    }));
    (0, react_1.useEffect)(function () {
        if (queryResult.data === undefined || queryResult.isFetching)
            return;
        onSuccessEvent(queryResult.data);
    }, [onSuccessEvent, queryResult.data, queryResult.isFetching]);
    (0, react_1.useEffect)(function () {
        if (queryResult.error == null || queryResult.isFetching)
            return;
        onErrorEvent(queryResult.error);
    }, [onErrorEvent, queryResult.error, queryResult.isFetching]);
    (0, react_1.useEffect)(function () {
        if (queryResult.status === 'pending' || queryResult.isFetching)
            return;
        onSettledEvent(queryResult.data, queryResult.error);
    }, [
        onSettledEvent,
        queryResult.data,
        queryResult.error,
        queryResult.status,
        queryResult.isFetching,
    ]);
    var result = (0, react_1.useMemo)(function () { return (__assign(__assign({}, queryResult), { permissions: queryResult.data })); }, [queryResult]);
    return !authProvider || !authProvider.getPermissions
        ? fakeQueryResult
        : result;
};
exports.default = usePermissions;
var noop = function () { };
var fakeQueryResult = {
    permissions: undefined,
    data: undefined,
    dataUpdatedAt: 0,
    error: null,
    errorUpdatedAt: 0,
    errorUpdateCount: 0,
    failureCount: 0,
    failureReason: null,
    fetchStatus: 'idle',
    isError: false,
    isInitialLoading: false,
    isLoading: false,
    isLoadingError: false,
    isFetched: true,
    isFetchedAfterMount: true,
    isFetching: false,
    isPaused: false,
    isPlaceholderData: false,
    isPending: false,
    isRefetchError: false,
    isRefetching: false,
    isStale: false,
    isSuccess: true,
    status: 'success',
    refetch: function () { return Promise.resolve(fakeQueryResult); },
};
//# sourceMappingURL=usePermissions.js.map