import * as React from 'react';
import { ReactNode } from 'react';
import { CreateControllerResult } from './useCreateController';
/**
 * Create a Create Context.
 *
 * @example
 *
 * const MyCreate = (props) => {
 *     const controllerProps = useCreateController(props);
 *     return (
 *         <CreateContextProvider value={controllerProps}>
 *             <MyCreateView>
 *         </CreateContextProvider>
 *     );
 * };
 *
 * const MyCreateView = () => {
 *     const record = useRecordContext();
 *     // or, to rerender only when the save operation change but not data
 *     const { saving } = useCreateContext();
 * }
 *
 * @see CreateContext
 * @see RecordContext
 */
export declare const CreateContextProvider: ({ children, value, }: {
    children: ReactNode;
    value: CreateControllerResult;
}) => React.JSX.Element;
//# sourceMappingURL=CreateContextProvider.d.ts.map