import { ReactNode } from 'react';
import { CreateControllerProps, CreateControllerResult } from './useCreateController';
/**
 * Render prop version of the useCreateController hook
 *
 * @see useCreateController
 * @example
 *
 * const CreateView = () => <div>...</div>
 * const MyCreate = props => (
 *     <CreateController {...props}>
 *         {controllerProps => <CreateView {...controllerProps} {...props} />}
 *     </CreateController>
 * );
 */
export declare const CreateController: ({ children, ...props }: {
    children: (params: CreateControllerResult) => ReactNode;
} & CreateControllerProps<any, Error, any>) => ReactNode;
//# sourceMappingURL=CreateController.d.ts.map