"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useCreateContext = void 0;
var react_1 = require("react");
var CreateContext_1 = require("./CreateContext");
/**
 * Hook to read the create controller props from the CreateContext.
 *
 * Used within a <CreateContextProvider> (e.g. as a descendent of <Create>).
 *
 * @returns {CreateControllerResult} create controller props
 *
 * @see useCreateController for how it is filled
 */
var useCreateContext = function () {
    var context = (0, react_1.useContext)(CreateContext_1.CreateContext);
    if (!context) {
        throw new Error('useCreateContext must be used inside a CreateContextProvider');
    }
    return context;
};
exports.useCreateContext = useCreateContext;
//# sourceMappingURL=useCreateContext.js.map