"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useEditContext = void 0;
var react_1 = require("react");
var EditContext_1 = require("./EditContext");
/**
 * Hook to read the edit controller props from the EditContext.
 *
 * Used within a <EditContextProvider> (e.g. as a descendent of <Edit>).
 *
 * @returns {EditControllerResult} edit controller props
 *
 * @see useEditController for how it is filled
 */
var useEditContext = function () {
    var context = (0, react_1.useContext)(EditContext_1.EditContext);
    if (!context) {
        throw new Error('useEditContext must be used inside an EditContextProvider');
    }
    return context;
};
exports.useEditContext = useEditContext;
//# sourceMappingURL=useEditContext.js.map