"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useReferenceFieldController = void 0;
var react_1 = require("react");
var routing_1 = require("../../routing");
var useReference_1 = require("../useReference");
var util_1 = require("../../util");
var useReferenceFieldController = function (options) {
    var link = options.link, reference = options.reference, queryOptions = options.queryOptions;
    if (!reference) {
        throw new Error('useReferenceFieldController: missing reference prop. You must provide a reference, e.g. reference="posts".');
    }
    var id = (0, util_1.useFieldValue)(options);
    var referenceRecordQuery = (0, useReference_1.useReference)({
        reference: reference,
        id: id,
        options: __assign(__assign({}, queryOptions), { enabled: ((queryOptions === null || queryOptions === void 0 ? void 0 : queryOptions.enabled) == null ||
                (queryOptions === null || queryOptions === void 0 ? void 0 : queryOptions.enabled) === true) &&
                id != null }),
    });
    var path = (0, routing_1.useGetPathForRecord)({
        record: referenceRecordQuery.referenceRecord,
        resource: reference,
        link: link,
    });
    var result = (0, react_1.useMemo)(function () {
        return (__assign(__assign({}, referenceRecordQuery), { link: path }));
    }, [path, referenceRecordQuery]);
    return result;
};
exports.useReferenceFieldController = useReferenceFieldController;
//# sourceMappingURL=useReferenceFieldController.js.map