"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.queryReducer = exports.HIDE_FILTER = exports.SHOW_FILTER = exports.SET_FILTER = exports.SET_PER_PAGE = exports.SET_PAGE = exports.SORT_DESC = exports.SORT_ASC = exports.SET_SORT = void 0;
var set_1 = __importDefault(require("lodash/set"));
var removeEmpty_1 = __importDefault(require("../../util/removeEmpty"));
var removeKey_1 = __importDefault(require("../../util/removeKey"));
exports.SET_SORT = 'SET_SORT';
exports.SORT_ASC = 'ASC';
exports.SORT_DESC = 'DESC';
exports.SET_PAGE = 'SET_PAGE';
exports.SET_PER_PAGE = 'SET_PER_PAGE';
exports.SET_FILTER = 'SET_FILTER';
exports.SHOW_FILTER = 'SHOW_FILTER';
exports.HIDE_FILTER = 'HIDE_FILTER';
var oppositeOrder = function (direction) {
    return direction === exports.SORT_DESC ? exports.SORT_ASC : exports.SORT_DESC;
};
/**
 * This reducer is for the react-router query string.
 */
var queryReducer = function (previousState, action) {
    var _a;
    var _b;
    switch (action.type) {
        case exports.SET_SORT:
            if (action.payload.field === previousState.sort) {
                return __assign(__assign({}, previousState), { order: (_b = action.payload.order) !== null && _b !== void 0 ? _b : oppositeOrder(previousState.order), page: 1 });
            }
            return __assign(__assign({}, previousState), { sort: action.payload.field, order: action.payload.order || exports.SORT_ASC, page: 1 });
        case exports.SET_PAGE:
            return __assign(__assign({}, previousState), { page: action.payload });
        case exports.SET_PER_PAGE:
            return __assign(__assign({}, previousState), { page: 1, perPage: action.payload });
        case exports.SET_FILTER: {
            return __assign(__assign({}, previousState), { page: 1, filter: action.payload.filter, displayedFilters: action.payload.displayedFilters
                    ? action.payload.displayedFilters
                    : previousState.displayedFilters });
        }
        case exports.SHOW_FILTER: {
            if (previousState.displayedFilters &&
                previousState.displayedFilters[action.payload.filterName]) {
                // the filter is already shown
                return previousState;
            }
            return __assign(__assign({}, previousState), { filter: typeof action.payload.defaultValue !== 'undefined'
                    ? (0, set_1.default)(previousState.filter, action.payload.filterName, action.payload.defaultValue)
                    : previousState.filter, 
                // we don't use lodash.set() for displayed filters
                // to avoid problems with compound filter names (e.g. 'author.name')
                displayedFilters: __assign(__assign({}, previousState.displayedFilters), (_a = {}, _a[action.payload.filterName] = true, _a)) });
        }
        case exports.HIDE_FILTER: {
            return __assign(__assign({}, previousState), { filter: (0, removeEmpty_1.default)((0, removeKey_1.default)(previousState.filter, action.payload)), 
                // we don't use lodash.set() for displayed filters
                // to avoid problems with compound filter names (e.g. 'author.name')
                displayedFilters: previousState.displayedFilters
                    ? Object.keys(previousState.displayedFilters).reduce(function (filters, filter) {
                        var _a;
                        return filter !== action.payload
                            ? __assign(__assign({}, filters), (_a = {}, _a[filter] = true, _a)) : filters;
                    }, {})
                    : previousState.displayedFilters });
        }
        default:
            return previousState;
    }
};
exports.queryReducer = queryReducer;
exports.default = exports.queryReducer;
//# sourceMappingURL=queryReducer.js.map