"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useInfiniteListController = void 0;
var react_1 = require("react");
var auth_1 = require("../../auth");
var i18n_1 = require("../../i18n");
var notification_1 = require("../../notification");
var dataProvider_1 = require("../../dataProvider");
var export_1 = require("../../export");
var core_1 = require("../../core");
var useRecordSelection_1 = require("./useRecordSelection");
var useListParams_1 = require("./useListParams");
/**
 * Prepare data for the InfiniteList view
 *
 * @param {Object} props The props passed to the InfiniteList component.
 *
 * @return {Object} controllerProps Fetched and computed data for the List view
 *
 * @example
 *
 * import { useInfiniteListController } from 'react-admin';
 * import ListView from './ListView';
 *
 * const MyList = props => {
 *     const controllerProps = useInfiniteListController(props);
 *     return <ListView {...controllerProps} {...props} />;
 * }
 */
var useInfiniteListController = function (props) {
    if (props === void 0) { props = {}; }
    var _a = props.debounce, debounce = _a === void 0 ? 500 : _a, _b = props.disableAuthentication, disableAuthentication = _b === void 0 ? false : _b, _c = props.disableSyncWithLocation, disableSyncWithLocation = _c === void 0 ? false : _c, _d = props.exporter, exporter = _d === void 0 ? export_1.defaultExporter : _d, filter = props.filter, filterDefaultValues = props.filterDefaultValues, _e = props.perPage, perPage = _e === void 0 ? 10 : _e, queryOptions = props.queryOptions, sort = props.sort, storeKey = props.storeKey;
    var resource = (0, core_1.useResourceContext)(props);
    var _f = queryOptions !== null && queryOptions !== void 0 ? queryOptions : {}, meta = _f.meta, otherQueryOptions = __rest(_f, ["meta"]);
    if (!resource) {
        throw new Error("<InfiniteList> was called outside of a ResourceContext and without a resource prop. You must set the resource prop.");
    }
    if (filter && (0, react_1.isValidElement)(filter)) {
        throw new Error('<InfiniteList> received a React element as `filter` props. If you intended to set the list filter elements, use the `filters` (with an s) prop instead. The `filter` prop is internal and should not be set by the developer.');
    }
    var isPendingAuthenticated = (0, auth_1.useAuthenticated)({
        enabled: !disableAuthentication,
    }).isPending;
    var isPendingCanAccess = (0, auth_1.useRequireAccess)({
        action: 'list',
        resource: resource,
        // If disableAuthentication is true then isPendingAuthenticated will always be true so this hook is disabled
        enabled: !isPendingAuthenticated,
    }).isPending;
    var translate = (0, i18n_1.useTranslate)();
    var notify = (0, notification_1.useNotify)();
    var _g = (0, useListParams_1.useListParams)({
        debounce: debounce,
        disableSyncWithLocation: disableSyncWithLocation,
        filterDefaultValues: filterDefaultValues,
        perPage: perPage,
        resource: resource,
        sort: sort,
        storeKey: storeKey,
    }), query = _g[0], queryModifiers = _g[1];
    var _h = (0, useRecordSelection_1.useRecordSelection)({ resource: resource }), selectedIds = _h[0], selectionModifiers = _h[1];
    var _j = (0, dataProvider_1.useInfiniteGetList)(resource, {
        pagination: {
            page: query.page,
            perPage: query.perPage,
        },
        sort: { field: query.sort, order: query.order },
        filter: __assign(__assign({}, query.filter), filter),
        meta: meta,
    }, __assign({ enabled: (!isPendingAuthenticated && !isPendingCanAccess) ||
            disableAuthentication, placeholderData: function (previousData) { return previousData; }, retry: false, onError: function (error) {
            return notify((error === null || error === void 0 ? void 0 : error.message) || 'ra.notification.http_error', {
                type: 'error',
                messageArgs: {
                    _: error === null || error === void 0 ? void 0 : error.message,
                },
            });
        } }, otherQueryOptions)), data = _j.data, total = _j.total, error = _j.error, isLoading = _j.isLoading, isPending = _j.isPending, isFetching = _j.isFetching, hasNextPage = _j.hasNextPage, hasPreviousPage = _j.hasPreviousPage, fetchNextPage = _j.fetchNextPage, isFetchingNextPage = _j.isFetchingNextPage, fetchPreviousPage = _j.fetchPreviousPage, isFetchingPreviousPage = _j.isFetchingPreviousPage, refetch = _j.refetch;
    // change page if there is no data
    (0, react_1.useEffect)(function () {
        if (query.page <= 0 ||
            (!isFetching &&
                query.page > 1 &&
                (data == null || (data === null || data === void 0 ? void 0 : data.pages.length) === 0))) {
            // Query for a page that doesn't exist, set page to 1
            queryModifiers.setPage(1);
            return;
        }
        if (total == null) {
            return;
        }
        var totalPages = Math.ceil(total / query.perPage) || 1;
        if (!isFetching && query.page > totalPages) {
            // Query for a page out of bounds, set page to the last existing page
            // It occurs when deleting the last element of the last page
            queryModifiers.setPage(totalPages);
        }
    }, [isFetching, query.page, query.perPage, data, queryModifiers, total]);
    var currentSort = (0, react_1.useMemo)(function () { return ({
        field: query.sort,
        order: query.order,
    }); }, [query.sort, query.order]);
    var getResourceLabel = (0, core_1.useGetResourceLabel)();
    var defaultTitle = translate('ra.page.list', {
        name: getResourceLabel(resource, 2),
    });
    var unwrappedData = (0, react_1.useMemo)(function () { var _a; return (_a = data === null || data === void 0 ? void 0 : data.pages) === null || _a === void 0 ? void 0 : _a.reduce(function (acc, page) { return __spreadArray(__spreadArray([], acc, true), page.data, true); }, []); }, [data]);
    return {
        sort: currentSort,
        data: unwrappedData,
        defaultTitle: defaultTitle,
        displayedFilters: query.displayedFilters,
        error: error,
        exporter: exporter,
        filter: filter,
        filterValues: query.filterValues,
        hideFilter: queryModifiers.hideFilter,
        isFetching: isFetching,
        isLoading: isLoading,
        isPending: isPending,
        onSelect: selectionModifiers.select,
        onToggleItem: selectionModifiers.toggle,
        onUnselectItems: selectionModifiers.clearSelection,
        page: query.page,
        perPage: query.perPage,
        refetch: refetch,
        resource: resource,
        selectedIds: selectedIds,
        setFilters: queryModifiers.setFilters,
        setPage: queryModifiers.setPage,
        setPerPage: queryModifiers.setPerPage,
        setSort: queryModifiers.setSort,
        showFilter: queryModifiers.showFilter,
        total: total,
        hasNextPage: hasNextPage,
        hasPreviousPage: hasPreviousPage,
        fetchNextPage: fetchNextPage,
        isFetchingNextPage: isFetchingNextPage,
        fetchPreviousPage: fetchPreviousPage,
        isFetchingPreviousPage: isFetchingPreviousPage,
    };
};
exports.useInfiniteListController = useInfiniteListController;
//# sourceMappingURL=useInfiniteListController.js.map