"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useInfinitePaginationContext = void 0;
var react_1 = require("react");
var InfinitePaginationContext_1 = require("./InfinitePaginationContext");
/**
 * Hook to read the infinite pagination callbacks from the InfinitePaginationContext.
 *
 * Must be used within a <InfinitePaginationContext.Provider> (e.g. as a descendent of <InfiniteList>
 * or <InfiniteListBase>).
 *
 * @typedef {Object} InfinitePaginationContextValue
 * @prop {Function} fetchNextPage a callback to fetch the next page
 * @prop {Function} fetchPreviousPage a callback to fetch the previous page
 *
 * @returns {InfinitePaginationContextValue} infinite pagination callbacks
 *
 * @see useInfiniteListController for how the callbacks are built
 */
var useInfinitePaginationContext = function () { return (0, react_1.useContext)(InfinitePaginationContext_1.InfinitePaginationContext); };
exports.useInfinitePaginationContext = useInfinitePaginationContext;
//# sourceMappingURL=useInfinitePaginationContext.js.map