"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useListFilterContext = void 0;
var react_1 = require("react");
var ListFilterContext_1 = require("./ListFilterContext");
/**
 * Hook to read the list props from the ListFilterContext.
 *
 * Must be used within a <ListFilterContextProvider>.
 *
 * @returns {ListFilterContextValue} list controller props
 *
 * @see useListController for how it is filled
 */
var useListFilterContext = function () {
    var context = (0, react_1.useContext)(ListFilterContext_1.ListFilterContext);
    if (!context) {
        throw new Error('useListFilterContext must be used inside a ListFilterContextProvider');
    }
    return context;
};
exports.useListFilterContext = useListFilterContext;
//# sourceMappingURL=useListFilterContext.js.map