"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useListPaginationContext = void 0;
var react_1 = require("react");
var ListPaginationContext_1 = require("./ListPaginationContext");
/**
 * Hook to read the list pagination controller props from the ListPaginationContext.
 *
 * Must be used within a <ListPaginationContext> (e.g. as a descendent of <List>
 * or <ListBase>).
 *
 * @returns {ListPaginationContextValue} list controller props
 *
 * @see useListController for how it is filled
 */
var useListPaginationContext = function () {
    var context = (0, react_1.useContext)(ListPaginationContext_1.ListPaginationContext);
    if (!context) {
        throw new Error('useListPaginationContext must be used inside a ListPaginationContextProvider');
    }
    return context;
};
exports.useListPaginationContext = useListPaginationContext;
//# sourceMappingURL=useListPaginationContext.js.map