"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useListSortContext = void 0;
var react_1 = require("react");
var ListSortContext_1 = require("./ListSortContext");
/**
 * Hook to read the list sort controller props from the ListSortContext.
 *
 * Must be used within a <ListSortContextProvider> (e.g. as a descendent of <List>
 * or <ListBase>).
 *
 * @returns {ListSortContextValue} list controller props
 *
 * @see useListController for how it is filled
 */
var useListSortContext = function () {
    var context = (0, react_1.useContext)(ListSortContext_1.ListSortContext);
    if (!context) {
        throw new Error('useListSortContext must be used inside a ListSortContextProvider');
    }
    return context;
};
exports.useListSortContext = useListSortContext;
//# sourceMappingURL=useListSortContext.js.map