import * as React from 'react';
import { ReactNode } from 'react';
import { RaRecord } from '../../types';
/**
 * Context to store a record.
 *
 * @see RecordContextProvider
 * @see useRecordContext
 */
export declare const RecordContext: React.Context<RaRecord<import("../../types").Identifier> | Omit<RaRecord<import("../../types").Identifier>, "id"> | undefined>;
/**
 * Provider for the Record Context, to store a record.
 *
 * Use the useRecordContext() hook to read the context.
 * That's what the Edit and Show components do in react-admin.
 *
 * Many react-admin components read the RecordContext, including all Field
 * components.
 *
 * @example
 *
 * import { useGetOne, RecordContextProvider } from 'ra-core';
 *
 * const Show = ({ resource, id }) => {
 *     const { data } = useGetOne(resource, { id });
 *     return (
 *         <RecordContextProvider value={data}>
 *             ...
 *         </RecordContextProvider>
 *     );
 * };
 */
export declare const RecordContextProvider: <RecordType extends RaRecord<import("../../types").Identifier> | Omit<RaRecord<import("../../types").Identifier>, "id"> = RaRecord<import("../../types").Identifier>>({ children, value, }: RecordContextProviderProps<RecordType>) => React.JSX.Element;
export interface RecordContextProviderProps<RecordType> {
    children: ReactNode;
    value?: RecordType;
}
//# sourceMappingURL=RecordContext.d.ts.map