"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePickSaveContext = void 0;
var react_1 = require("react");
var pick_1 = __importDefault(require("lodash/pick"));
/**
 * This hook extracts the `save`, `saving` and mutationMode properties from either the `CreateContext` or `EditContext`. This ensures the `SaveContext` doesn't rerender when those two contexts have other properties changes.
 */
var usePickSaveContext = function (context) {
    var value = (0, react_1.useMemo)(function () {
        return (0, pick_1.default)(context, [
            'save',
            'saving',
            'mutationMode',
            'registerMutationMiddleware',
            'unregisterMutationMiddleware',
        ]);
    }, 
    /* eslint-disable react-hooks/exhaustive-deps */
    [
        context.save,
        context.saving,
        context.mutationMode,
        context.registerMutationMiddleware,
        context.unregisterMutationMiddleware,
    ]
    /* eslint-enable react-hooks/exhaustive-deps */
    );
    return value;
};
exports.usePickSaveContext = usePickSaveContext;
//# sourceMappingURL=usePickSaveContext.js.map