"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRegisterMutationMiddleware = void 0;
var react_1 = require("react");
var useSaveContext_1 = require("./useSaveContext");
/**
 * Internal hook that registers a middleware for the save function in the current SaveContext.
 * @param callback The middleware function.
 */
var useRegisterMutationMiddleware = function (callback) {
    var _a = (0, useSaveContext_1.useSaveContext)(), registerMutationMiddleware = _a.registerMutationMiddleware, unregisterMutationMiddleware = _a.unregisterMutationMiddleware;
    (0, react_1.useEffect)(function () {
        if (!registerMutationMiddleware || !unregisterMutationMiddleware) {
            return;
        }
        registerMutationMiddleware(callback);
        return function () {
            unregisterMutationMiddleware(callback);
        };
    }, [callback, registerMutationMiddleware, unregisterMutationMiddleware]);
};
exports.useRegisterMutationMiddleware = useRegisterMutationMiddleware;
//# sourceMappingURL=useRegisterMutationMiddleware.js.map