import { RaRecord } from '../../types';
import { ShowControllerResult } from './useShowController';
/**
 * Hook to read the show controller props from the ShowContext.
 *
 * Used within a <ShowContextProvider> (e.g. as a descendent of <Show>).
 *
 * @returns {ShowControllerResult} create controller props
 *
 * @see useShowController for how it is filled
 */
export declare const useShowContext: <RecordType extends RaRecord<import("../../types").Identifier> = any>() => ShowControllerResult<RecordType>;
//# sourceMappingURL=useShowContext.d.ts.map