"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useShowContext = void 0;
var react_1 = require("react");
var ShowContext_1 = require("./ShowContext");
/**
 * Hook to read the show controller props from the ShowContext.
 *
 * Used within a <ShowContextProvider> (e.g. as a descendent of <Show>).
 *
 * @returns {ShowControllerResult} create controller props
 *
 * @see useShowController for how it is filled
 */
var useShowContext = function () {
    var context = (0, react_1.useContext)(ShowContext_1.ShowContext);
    // Props take precedence over the context
    if (!context) {
        throw new Error('useShowContext must be used inside a ShowContextProvider');
    }
    return context;
};
exports.useShowContext = useShowContext;
//# sourceMappingURL=useShowContext.js.map