import { RaRecord } from '../../types';
import { UseGetOneHookValue, UseGetOneOptions } from '../../dataProvider';
/**
 * Prepare data for the Show view.
 *
 * useShowController does a few things:
 * - it grabs the id from the URL and the resource name from the ResourceContext,
 * - it fetches the record via useGetOne,
 * - it prepares the page title.
 *
 * @param {Object} props The props passed to the Show component.
 *
 * @return {Object} controllerProps Fetched data and callbacks for the Show view
 *
 * @example
 *
 * import { useShowController } from 'react-admin';
 * import ShowView from './ShowView';
 *
 * const MyShow = () => {
 *     const controllerProps = useShowController();
 *     return <ShowView {...controllerProps} />;
 * };
 *
 * @example // useShowController can also take its parameters from props
 *
 * import { useShowController } from 'react-admin';
 * import ShowView from './ShowView';
 *
 * const MyShow = () => {
 *     const controllerProps = useShowController({ resource: 'posts', id: 1234 });
 *     return <ShowView {...controllerProps} />;
 * };
 */
export declare const useShowController: <RecordType extends RaRecord<import("../../types").Identifier> = any>(props?: ShowControllerProps<RecordType>) => ShowControllerResult<RecordType>;
export interface ShowControllerProps<RecordType extends RaRecord = any> {
    disableAuthentication?: boolean;
    id?: RecordType['id'];
    queryOptions?: UseGetOneOptions<RecordType>;
    resource?: string;
}
export interface ShowControllerBaseResult<RecordType extends RaRecord = any> {
    defaultTitle?: string;
    isFetching: boolean;
    isLoading: boolean;
    resource: string;
    record?: RecordType;
    refetch: UseGetOneHookValue<RecordType>['refetch'];
}
export interface ShowControllerLoadingResult<RecordType extends RaRecord = any> extends ShowControllerBaseResult<RecordType> {
    record: undefined;
    error: null;
    isPending: true;
}
export interface ShowControllerLoadingErrorResult<RecordType extends RaRecord = any, TError = Error> extends ShowControllerBaseResult<RecordType> {
    record: undefined;
    error: TError;
    isPending: false;
}
export interface ShowControllerRefetchErrorResult<RecordType extends RaRecord = any, TError = Error> extends ShowControllerBaseResult<RecordType> {
    record: RecordType;
    error: TError;
    isPending: false;
}
export interface ShowControllerSuccessResult<RecordType extends RaRecord = any> extends ShowControllerBaseResult<RecordType> {
    record: RecordType;
    error: null;
    isPending: false;
}
export type ShowControllerResult<RecordType extends RaRecord = any> = ShowControllerLoadingResult<RecordType> | ShowControllerLoadingErrorResult<RecordType> | ShowControllerRefetchErrorResult<RecordType> | ShowControllerSuccessResult<RecordType>;
//# sourceMappingURL=useShowController.d.ts.map