"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePrevNextController = void 0;
var react_query_1 = require("@tanstack/react-query");
var core_1 = require("../core");
var dataProvider_1 = require("../dataProvider");
var store_1 = require("../store");
var list_1 = require("./list");
var record_1 = require("./record");
var routing_1 = require("../routing");
/**
 * A hook used to fetch the previous and next record identifiers for a given record and resource.
 *
 * It fetches the list of records according to the filters
 * and the sort order configured in the list, and merges
 * the filters and the sorting order passed as props.
 *
 * usePrevNextController can be used anywhere a record context is provided
 * (often inside a `<Show>` or `<Edit>` component).
 *
 * @example <caption>Simple usage</caption>
 *
 * import { usePrevNextControllerProps } from 'ra-core';
 * const {
 *         hasPrev,
 *         hasNext,
 *         prevPath,
 *         nextPath,
 *         index,
 *         total,
 *         error,
 *         isPending,
 *     } = usePrevNextController(props);
 *
 * @example <caption>Custom PrevNextButton</caption>
 *
 * import { UsePrevNextControllerProps, useTranslate } from 'ra-core';
 * import NavigateBefore from '@mui/icons-material/NavigateBefore';
 * import NavigateNext from '@mui/icons-material/NavigateNext';
 * import ErrorIcon from '@mui/icons-material/Error';
 * import { Link } from 'react-router-dom';
 * import { CircularProgress, IconButton } from '@mui/material';
 *
 * const MyPrevNextButtons = props => {
 *     const {
 *         hasPrev,
 *         hasNext,
 *         nextPath,
 *         prevPath,
 *         index,
 *         total,
 *         error,
 *         isPending,
 *     } = usePrevNextController(props);
 *
 *     const translate = useTranslate();
 *
 *     if (isPending) {
 *         return <CircularProgress size={14} />;
 *     }
 *
 *     if (error) {
 *         return (
 *             <ErrorIcon
 *                 color="error"
 *                 fontSize="small"
 *                 titleAccess="error"
 *                 aria-errormessage={error.message}
 *             />
 *         );
 *     }
 *
 *     return (
 *         <ul>
 *             <li>
 *                 <IconButton
 *                     component={hasPrev ? Link : undefined}
 *                     to={navigateToPrev}
 *                     aria-label={translate('ra.navigation.previous')}
 *                     disabled={!hasPrev}
 *                 >
 *                     <NavigateBefore />
 *                 </IconButton>
 *             </li>
 *             {typeof index === 'number' && (
 *                 <li>
 *                     {index + 1} / {total}
 *                 </li>
 *             )}
 *             <li>
 *                 <IconButton
 *                     component={hasNext ? Link : undefined}
 *                     to={navigateToNext}
 *                     aria-label={translate('ra.navigation.next')}
 *                     disabled={!hasNext}
 *                 >
 *                     <NavigateNext />
 *                 </IconButton>
 *             </li>
 *         </ul>
 *     );
 * };
 */
var usePrevNextController = function (props) {
    var _a, _b, _c, _d;
    var _e = props.linkType, linkType = _e === void 0 ? 'edit' : _e, storeKey = props.storeKey, _f = props.limit, limit = _f === void 0 ? 1000 : _f, _g = props.sort, initialSort = _g === void 0 ? { field: 'id', order: list_1.SORT_ASC } : _g, _h = props.filter, permanentFilter = _h === void 0 ? {} : _h, _j = props.filterDefaultValues, filterDefaultValues = _j === void 0 ? {} : _j, _k = props.queryOptions, queryOptions = _k === void 0 ? {
        staleTime: 5 * 60 * 1000,
    } : _k;
    var record = (0, record_1.useRecordContext)(props);
    var resource = (0, core_1.useResourceContext)(props);
    var createPath = (0, routing_1.useCreatePath)();
    if (!resource) {
        throw new Error("useNextPrevController was called outside of a ResourceContext and without a resource prop. You must set the resource prop.");
    }
    var storedParams = (0, store_1.useStore)(storeKey || "".concat(resource, ".listParams"), {
        filter: filterDefaultValues,
        order: initialSort.order,
        sort: initialSort.field,
        page: 1,
        perPage: 10,
        displayedFilters: {},
    })[0];
    var dataProvider = (0, dataProvider_1.useDataProvider)();
    var queryClient = (0, react_query_1.useQueryClient)();
    var pagination = { page: 1, perPage: limit };
    var sort = {
        field: storedParams.sort,
        order: storedParams.order,
    };
    var filter = __assign(__assign({}, storedParams.filter), permanentFilter);
    var meta = queryOptions.meta, otherQueryOptions = __rest(queryOptions, ["meta"]);
    var params = { pagination: pagination, sort: sort, filter: filter, meta: meta };
    // try to use data from the cache first
    var queryData = queryClient.getQueryData([
        resource,
        'getList',
        __assign(__assign({}, params), { pagination: {
                page: storedParams.page,
                perPage: storedParams.perPage,
            } }),
    ]);
    var recordIndexInQueryData = (_a = queryData === null || queryData === void 0 ? void 0 : queryData.data) === null || _a === void 0 ? void 0 : _a.findIndex(function (r) { return r.id === (record === null || record === void 0 ? void 0 : record.id); });
    var isRecordIndexFirstInNonFirstPage = recordIndexInQueryData === 0 && storedParams.page > 1;
    var isRecordIndexLastInNonLastPage = (queryData === null || queryData === void 0 ? void 0 : queryData.data) && (queryData === null || queryData === void 0 ? void 0 : queryData.total)
        ? recordIndexInQueryData === ((_b = queryData === null || queryData === void 0 ? void 0 : queryData.data) === null || _b === void 0 ? void 0 : _b.length) - 1 &&
            storedParams.page < (queryData === null || queryData === void 0 ? void 0 : queryData.total) / storedParams.perPage
        : undefined;
    var canUseCacheData = record &&
        (queryData === null || queryData === void 0 ? void 0 : queryData.data) &&
        recordIndexInQueryData !== -1 &&
        !isRecordIndexFirstInNonFirstPage &&
        !isRecordIndexLastInNonLastPage;
    // If the previous and next ids are not in the cache, fetch the entire list.
    // This is necessary e.g. when coming directly to a detail page,
    // without displaying the list first
    var _l = (0, react_query_1.useQuery)(__assign({ queryKey: [resource, 'getList', params], queryFn: function (queryParams) {
            return dataProvider.getList(resource, __assign(__assign({}, params), { signal: dataProvider.supportAbortSignal === true
                    ? queryParams.signal
                    : undefined }));
        }, enabled: !canUseCacheData }, otherQueryOptions)), data = _l.data, error = _l.error, isFetching = _l.isFetching, isLoading = _l.isLoading, isPending = _l.isPending;
    var finalData = canUseCacheData ? queryData.data : (data === null || data === void 0 ? void 0 : data.data) || [];
    if (!record || (isPending && !canUseCacheData))
        return {
            isFetching: true,
            isLoading: true,
            isPending: true,
            prevPath: undefined,
            nextPath: undefined,
            index: undefined,
            total: undefined,
            hasPrev: false,
            hasNext: false,
        };
    var ids = finalData.map(function (record) { return record.id; });
    var index = ids.indexOf(record.id);
    var previousId = typeof ids[index - 1] !== 'undefined' ? ids[index - 1] : null; // could be 0
    var nextId = index !== -1 && index < ids.length - 1 ? ids[index + 1] : null;
    return {
        hasPrev: previousId !== null,
        hasNext: nextId !== null,
        prevPath: previousId !== null
            ? createPath({
                type: linkType,
                resource: resource,
                id: previousId,
            })
            : undefined,
        nextPath: nextId !== null
            ? createPath({
                type: linkType,
                resource: resource,
                id: nextId,
            })
            : undefined,
        index: index === -1
            ? undefined
            : index +
                (canUseCacheData
                    ? ((_c = storedParams.perPage) !== null && _c !== void 0 ? _c : 0) *
                        (((_d = storedParams.page) !== null && _d !== void 0 ? _d : 1) - 1)
                    : 0),
        total: canUseCacheData ? queryData === null || queryData === void 0 ? void 0 : queryData.total : data === null || data === void 0 ? void 0 : data.total,
        error: error,
        isFetching: canUseCacheData ? false : isFetching,
        isLoading: canUseCacheData ? false : isLoading,
        isPending: canUseCacheData ? false : isPending,
    };
};
exports.usePrevNextController = usePrevNextController;
//# sourceMappingURL=usePrevNextController.js.map