"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useReference = void 0;
var dataProvider_1 = require("../dataProvider");
/**
 * @typedef UseReferenceResult
 * @type {Object}
 * @property {boolean} isFetching: boolean indicating if the reference is loading
 * @property {boolean} isLoading: boolean indicating if the reference has loaded at least once
 * @property {Object} referenceRecord: the referenced record.
 */
/**
 * Fetch reference record, and return it when available
 *
 * The reference prop should be the name of one of the <Resource> components
 * added as <Admin> child.
 *
 * @example
 *
 * const { isLoading, referenceRecord } = useReference({
 *     id: 7,
 *     reference: 'users',
 * });
 *
 * @param {Object} option
 * @param {string} option.reference The linked resource name
 * @param {string} option.id The id of the reference
 * @param {Object} option.options Options passed to the dataProvider
 *
 * @returns {UseReferenceResult} The reference record
 */
var useReference = function (_a) {
    var reference = _a.reference, id = _a.id, _b = _a.options, options = _b === void 0 ? {} : _b;
    var meta = options.meta, otherQueryOptions = __rest(options, ["meta"]);
    var _c = (0, dataProvider_1.useGetManyAggregate)(reference, { ids: [id], meta: meta }, otherQueryOptions), data = _c.data, error = _c.error, isLoading = _c.isLoading, isFetching = _c.isFetching, isPending = _c.isPending, refetch = _c.refetch;
    return {
        referenceRecord: error ? undefined : data ? data[0] : undefined,
        refetch: refetch,
        error: error,
        isLoading: isLoading,
        isFetching: isFetching,
        isPending: isPending,
    };
};
exports.useReference = useReference;
//# sourceMappingURL=useReference.js.map