"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreAdminRoutes = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var react_router_dom_1 = require("react-router-dom");
var auth_1 = require("../auth");
var routing_1 = require("../routing");
var useConfigureAdminRouterFromChildren_1 = require("./useConfigureAdminRouterFromChildren");
var HasDashboardContext_1 = require("./HasDashboardContext");
var NavigateToFirstResource_1 = require("./NavigateToFirstResource");
var CoreAdminRoutes = function (props) {
    (0, routing_1.useScrollToTop)();
    var _a = (0, useConfigureAdminRouterFromChildren_1.useConfigureAdminRouterFromChildren)(props.children), customRoutesWithLayout = _a.customRoutesWithLayout, customRoutesWithoutLayout = _a.customRoutesWithoutLayout, status = _a.status, resources = _a.resources;
    var Layout = props.layout, CatchAll = props.catchAll, dashboard = props.dashboard, LoadingPage = props.loading, requireAuth = props.requireAuth, Ready = props.ready, _b = props.authenticationError, AuthenticationError = _b === void 0 ? Noop : _b, _c = props.accessDenied, AccessDenied = _c === void 0 ? Noop : _c;
    var _d = (0, auth_1.useAuthState)(undefined, 
    // do not log the user out on failure to allow access to custom routes with no layout
    false, { enabled: requireAuth }), authenticated = _d.authenticated, isPendingAuthenticated = _d.isPending;
    if (status === 'empty') {
        if (!Ready) {
            throw new Error('The admin is empty. Please provide an empty component, or pass Resource or CustomRoutes as children.');
        }
        return React.createElement(Ready, null);
    }
    // Note: custom routes with no layout are always rendered, regardless of the auth status
    if (status === 'loading' || (requireAuth && isPendingAuthenticated)) {
        return (React.createElement(react_router_dom_1.Routes, null,
            customRoutesWithoutLayout,
            React.createElement(react_router_dom_1.Route, { path: "*", element: React.createElement("div", { style: { height: '100vh' } },
                    React.createElement(LoadingPage, null)) })));
    }
    if (requireAuth && (isPendingAuthenticated || !authenticated)) {
        return (React.createElement(react_router_dom_1.Routes, null,
            customRoutesWithoutLayout,
            React.createElement(react_router_dom_1.Route, { path: "*", element: React.createElement(auth_1.LogoutOnMount, null) })));
    }
    return (React.createElement(react_router_dom_1.Routes, null,
        customRoutesWithoutLayout,
        React.createElement(react_router_dom_1.Route, { path: "/*", element: React.createElement(HasDashboardContext_1.HasDashboardContextProvider, { value: !!dashboard },
                React.createElement(Layout, null,
                    React.createElement(react_router_dom_1.Routes, null,
                        customRoutesWithLayout,
                        react_1.Children.map(resources, function (resource) { return (React.createElement(react_router_dom_1.Route, { key: resource.props.name, path: "".concat(resource.props.name, "/*"), element: resource })); }),
                        React.createElement(react_router_dom_1.Route, { path: "/", element: dashboard ? (React.createElement(auth_1.WithPermissions, { authParams: defaultAuthParams, component: dashboard, loading: LoadingPage })) : (React.createElement(NavigateToFirstResource_1.NavigateToFirstResource, { loading: LoadingPage })) }),
                        React.createElement(react_router_dom_1.Route, { path: "/authentication-error", element: React.createElement(AuthenticationError, null) }),
                        React.createElement(react_router_dom_1.Route, { path: "/access-denied", element: React.createElement(AccessDenied, null) }),
                        React.createElement(react_router_dom_1.Route, { path: "*", element: React.createElement(CatchAll, null) })))) })));
};
exports.CoreAdminRoutes = CoreAdminRoutes;
// FIXME in v6: make dashboard anonymous by default to remove this hack
var defaultAuthParams = { params: { route: 'dashboard' } };
var Noop = function () { return null; };
//# sourceMappingURL=CoreAdminRoutes.js.map