"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreAdminUI = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var react_router_dom_1 = require("react-router-dom");
var react_error_boundary_1 = require("react-error-boundary");
var CoreAdminRoutes_1 = require("./CoreAdminRoutes");
var routing_1 = require("../routing");
var util_1 = require("../util");
var DefaultTitleContext_1 = require("./DefaultTitleContext");
var DefaultLayout = function (_a) {
    var children = _a.children;
    return (React.createElement(React.Fragment, null, children));
};
var DefaultError = function (_a) {
    var error = _a.error, errorInfo = _a.errorInfo, resetErrorBoundary = _a.resetErrorBoundary;
    (0, routing_1.useResetErrorBoundaryOnLocationChange)(resetErrorBoundary);
    return (React.createElement("div", null,
        React.createElement("h1", null, "Error"),
        React.createElement("pre", null,
            error.message, errorInfo === null || errorInfo === void 0 ? void 0 :
            errorInfo.componentStack)));
};
var CoreAdminUI = function (props) {
    var _a = (0, react_1.useState)({}), errorInfo = _a[0], setErrorInfo = _a[1];
    var _b = props.authCallbackPage, LoginCallbackPage = _b === void 0 ? false : _b, _c = props.catchAll, catchAll = _c === void 0 ? Noop : _c, children = props.children, dashboard = props.dashboard, _d = props.disableTelemetry, disableTelemetry = _d === void 0 ? false : _d, _e = props.error, ErrorComponent = _e === void 0 ? DefaultError : _e, _f = props.layout, layout = _f === void 0 ? DefaultLayout : _f, _g = props.loading, loading = _g === void 0 ? Noop : _g, _h = props.loginPage, LoginPage = _h === void 0 ? false : _h, _j = props.ready, ready = _j === void 0 ? util_1.Ready : _j, _k = props.requireAuth, requireAuth = _k === void 0 ? false : _k, _l = props.title, title = _l === void 0 ? 'React Admin' : _l, _m = props.authenticationError, authenticationError = _m === void 0 ? Noop : _m, _o = props.accessDenied, accessDenied = _o === void 0 ? Noop : _o;
    (0, react_1.useEffect)(function () {
        if (disableTelemetry ||
            process.env.NODE_ENV !== 'production' ||
            typeof window === 'undefined' ||
            typeof window.location === 'undefined' ||
            typeof Image === 'undefined') {
            return;
        }
        var img = new Image();
        img.src = "https://react-admin-telemetry.marmelab.com/react-admin-telemetry?domain=".concat(window.location.hostname);
    }, [disableTelemetry]);
    var handleError = function (error, info) { return setErrorInfo(info); };
    return (React.createElement(DefaultTitleContext_1.DefaultTitleContextProvider, { value: title },
        React.createElement(react_error_boundary_1.ErrorBoundary, { onError: handleError, fallbackRender: function (_a) {
                var error = _a.error, resetErrorBoundary = _a.resetErrorBoundary;
                return (React.createElement("div", { style: { minHeight: '100vh' } },
                    React.createElement(ErrorComponent, { error: error, errorInfo: errorInfo, resetErrorBoundary: resetErrorBoundary })));
            } },
            React.createElement(react_router_dom_1.Routes, null,
                LoginPage !== false && LoginPage !== true ? (React.createElement(react_router_dom_1.Route, { path: "/login", element: createOrGetElement(LoginPage) })) : null,
                LoginCallbackPage !== false &&
                    LoginCallbackPage !== true ? (React.createElement(react_router_dom_1.Route, { path: "/auth-callback", element: createOrGetElement(LoginCallbackPage) })) : null,
                React.createElement(react_router_dom_1.Route, { path: "/*", element: React.createElement(CoreAdminRoutes_1.CoreAdminRoutes, { catchAll: catchAll, dashboard: dashboard, layout: layout, loading: loading, requireAuth: requireAuth, ready: ready, authenticationError: authenticationError, accessDenied: accessDenied }, children) })))));
};
exports.CoreAdminUI = CoreAdminUI;
var createOrGetElement = function (el) { return ((0, react_1.isValidElement)(el) ? el : (0, react_1.createElement)(el)); };
var Noop = function () { return null; };
//# sourceMappingURL=CoreAdminUI.js.map