import * as React from 'react';
import { ReactElement } from 'react';
import { ResourceContextValue } from './ResourceContext';
/**
 * Wrap children with a ResourceContext provider only if the value is defined.
 *
 * Allows a component to work outside of a resource context.
 *
 * @example
 *
 * import { OptionalResourceContextProvider, EditButton } from 'react-admin';
 *
 * const Button = ({ resource }) => (
 *     <OptionalResourceContextProvider value={resource}>
 *         <EditButton />
 *     </OptionalResourceContextProvider>
 * );
 */
export declare const OptionalResourceContextProvider: ({ value, children, }: {
    value?: ResourceContextValue;
    children: ReactElement;
}) => React.JSX.Element;
//# sourceMappingURL=OptionalResourceContextProvider.d.ts.map