"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resource = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var react_router_dom_1 = require("react-router-dom");
var react_is_1 = require("react-is");
var ResourceContextProvider_1 = require("./ResourceContextProvider");
var RestoreScrollPosition_1 = require("../routing/RestoreScrollPosition");
var Resource = function (props) {
    var create = props.create, edit = props.edit, list = props.list, name = props.name, show = props.show;
    return (React.createElement(ResourceContextProvider_1.ResourceContextProvider, { value: name },
        React.createElement(react_router_dom_1.Routes, null,
            create && (React.createElement(react_router_dom_1.Route, { path: "create/*", element: getElement(create) })),
            show && React.createElement(react_router_dom_1.Route, { path: ":id/show/*", element: getElement(show) }),
            edit && React.createElement(react_router_dom_1.Route, { path: ":id/*", element: getElement(edit) }),
            list && (React.createElement(react_router_dom_1.Route, { path: "/*", element: React.createElement(RestoreScrollPosition_1.RestoreScrollPosition, { storeKey: "".concat(name, ".list.scrollPosition") }, getElement(list)) })),
            props.children)));
};
exports.Resource = Resource;
var getElement = function (ElementOrComponent) {
    if ((0, react_1.isValidElement)(ElementOrComponent)) {
        return ElementOrComponent;
    }
    if ((0, react_is_1.isValidElementType)(ElementOrComponent)) {
        var Element_1 = ElementOrComponent;
        return React.createElement(Element_1, null);
    }
    return null;
};
exports.Resource.raName = 'Resource';
exports.Resource.registerResource = function (_a) {
    var create = _a.create, edit = _a.edit, icon = _a.icon, list = _a.list, name = _a.name, options = _a.options, show = _a.show, recordRepresentation = _a.recordRepresentation, hasCreate = _a.hasCreate, hasEdit = _a.hasEdit, hasShow = _a.hasShow;
    return ({
        name: name,
        options: options,
        hasList: !!list,
        hasCreate: !!create || !!hasCreate,
        hasEdit: !!edit || !!hasEdit,
        hasShow: !!show || !!hasShow,
        icon: icon,
        recordRepresentation: recordRepresentation,
    });
};
//# sourceMappingURL=Resource.js.map