"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceDefinitionContextProvider = exports.ResourceDefinitionContext = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var isEqual_1 = __importDefault(require("lodash/isEqual"));
exports.ResourceDefinitionContext = (0, react_1.createContext)({
    definitions: {},
    register: function () { },
    unregister: function () { },
});
/**
 * Context to store the current resource Definition.
 *
 * Use the useResourceDefinition() hook to read the context.
 *
 * @example
 *
 * import { useResourceDefinition, useTranslate } from 'ra-core';
 *
 * const PostMenuItem = () => {
 *     const { name, icon } = useResourceDefinition({ resource: 'posts' });
 *
 *     return (
 *          <MenuItem>
 *              <ListItemIcon>{icon}</ListItemIcon>
 *              {name}
 *          </MenuItem>
 *     );
 * };
 */
var ResourceDefinitionContextProvider = function (_a) {
    var _b = _a.definitions, defaultDefinitions = _b === void 0 ? {} : _b, children = _a.children;
    var _c = (0, react_1.useState)(defaultDefinitions), definitions = _c[0], setState = _c[1];
    var register = (0, react_1.useCallback)(function (config) {
        setState(function (prev) {
            var _a;
            return (0, isEqual_1.default)(prev[config.name], config)
                ? prev
                : __assign(__assign({}, prev), (_a = {}, _a[config.name] = config, _a));
        });
    }, []);
    var unregister = (0, react_1.useCallback)(function (config) {
        setState(function (prev) {
            var _a = prev, _b = config.name, _ = _a[_b], rest = __rest(_a, [typeof _b === "symbol" ? _b : _b + ""]);
            return rest;
        });
    }, []);
    var contextValue = (0, react_1.useMemo)(function () { return ({ definitions: definitions, register: register, unregister: unregister }); }, [definitions] // eslint-disable-line react-hooks/exhaustive-deps
    );
    return (React.createElement(exports.ResourceDefinitionContext.Provider, { value: contextValue }, children));
};
exports.ResourceDefinitionContextProvider = ResourceDefinitionContextProvider;
//# sourceMappingURL=ResourceDefinitionContext.js.map