"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useOptionalSourceContext = exports.useSourceContext = exports.SourceContextProvider = exports.SourceContext = void 0;
var react_1 = require("react");
/**
 * Context that provides a function that accept a source and return getters for the modified source and label.
 *
 * This allows some special inputs to prefix or suffix the source of their children.
 *
 * @example
 * const sourceContext = {
 *  getSource: source => `coordinates.${source}`,
 *  getLabel: source => `resources.posts.fields.${source}`,
 * }
 * const CoordinatesInput = () => {
 *   return (
 *     <SourceContextProvider value={sourceContext}>
 *       <TextInput source="lat" />
 *       <TextInput source="lng" />
 *     </SourceContextProvider>
 *   );
 * };
 */
exports.SourceContext = (0, react_1.createContext)(undefined);
var defaultContextValue = {
    getSource: function (source) { return source; },
    getLabel: function (source) { return source; },
};
exports.SourceContextProvider = exports.SourceContext.Provider;
var useSourceContext = function () {
    var context = (0, react_1.useContext)(exports.SourceContext);
    if (!context) {
        return defaultContextValue;
    }
    return context;
};
exports.useSourceContext = useSourceContext;
var useOptionalSourceContext = function () { return (0, react_1.useContext)(exports.SourceContext); };
exports.useOptionalSourceContext = useOptionalSourceContext;
//# sourceMappingURL=SourceContext.js.map