import { ReactElement, ReactNode } from 'react';
import { AdminChildren, ResourceDefinition, ResourceProps } from '../types';
/**
 * This hook inspects the CoreAdminRouter children and returns them separated in three groups:
 * - Custom routes without layout
 * - Custom routes with layout
 * - Resources
 *
 * It also returns a status:
 * - loading: still loading children from a function child
 * - empty: no resources were provided among children
 * - ready: admin is ready to be rendered
 *
 * @example
 * const {
 *    customRoutesWithLayout,
 *    customRoutesWithoutLayout,
 *    resources,
 *    status,
 * } = useConfigureAdminRouterFromChildren(children);
 */
export declare const useConfigureAdminRouterFromChildren: (children: AdminChildren) => RoutesAndResources & {
    status: AdminRouterStatus;
};
type RoutesAndResources = {
    customRoutesWithLayout: ReactNode[];
    customRoutesWithoutLayout: ReactNode[];
    resources: (ReactElement & ResourceWithRegisterFunction)[];
};
type ResourceWithRegisterFunction = {
    registerResource: (props: ResourceProps, permissions: any) => ResourceDefinition;
};
type AdminRouterStatus = 'loading' | 'empty' | 'ready';
export {};
//# sourceMappingURL=useConfigureAdminRouterFromChildren.d.ts.map