"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useFirstResourceWithListAccess = void 0;
var useCanAccessResources_1 = require("../auth/useCanAccessResources");
var auth_1 = require("../auth");
var useResourceDefinitions_1 = require("./useResourceDefinitions");
/**
 * A hook that returns the first resource for which users have access to the list page.
 * It calls the `authProvider.canAccess` if available to check the permissions.
 */
var useFirstResourceWithListAccess = function () {
    var isPendingAuthenticated = (0, auth_1.useAuthenticated)().isPending;
    var resources = (0, useResourceDefinitions_1.useResourceDefinitions)();
    var resourcesNames = Object.keys(resources).filter(function (resource) { return resources[resource].hasList; });
    var _a = (0, useCanAccessResources_1.useCanAccessResources)({
        action: 'list',
        resources: resourcesNames,
        enabled: !isPendingAuthenticated,
    }), canAccess = _a.canAccess, isPending = _a.isPending;
    var firstResourceWithListAccess = resourcesNames.find(function (resource) { return canAccess && canAccess[resource] === true; });
    return { resource: firstResourceWithListAccess, isPending: isPending };
};
exports.useFirstResourceWithListAccess = useFirstResourceWithListAccess;
//# sourceMappingURL=useFirstResourceWithListAccess.js.map