"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useResourceDefinition = void 0;
var react_1 = require("react");
var defaults_1 = __importDefault(require("lodash/defaults"));
var useResourceDefinitions_1 = require("./useResourceDefinitions");
var useResourceContext_1 = require("./useResourceContext");
/**
 * Hook to get the definition of a given resource
 *
 * @example // Get the current resource definition (based on ResourceContext)
 *
 * const definition = useResourceDefinition();
 * console.log(definition);
 * // {
 * //   name: 'posts',
 * //   hasList: true,
 * //   hasEdit: true,
 * //   hasShow: true,
 * //   hasCreate: true,
 * //   options: {},
 * //   icon: PostIcon,
 * // }
 *
 * @example // Pass a resource prop to check a different resource definition
 *
 * const definition = useResourceDefinition({ resource: 'posts' });
 */
var useResourceDefinition = function (props) {
    var resource = (0, useResourceContext_1.useResourceContext)(props);
    var resourceDefinitions = (0, useResourceDefinitions_1.useResourceDefinitions)();
    var _a = props || {}, hasCreate = _a.hasCreate, hasEdit = _a.hasEdit, hasList = _a.hasList, hasShow = _a.hasShow, recordRepresentation = _a.recordRepresentation;
    var definition = (0, react_1.useMemo)(function () {
        return (0, defaults_1.default)({}, {
            hasCreate: hasCreate,
            hasEdit: hasEdit,
            hasList: hasList,
            hasShow: hasShow,
            recordRepresentation: recordRepresentation,
        }, resource ? resourceDefinitions[resource] : {});
    }, [
        resource,
        resourceDefinitions,
        hasCreate,
        hasEdit,
        hasList,
        hasShow,
        recordRepresentation,
    ]);
    return definition;
};
exports.useResourceDefinition = useResourceDefinition;
//# sourceMappingURL=useResourceDefinition.js.map