"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useResourceDefinitions = void 0;
var useResourceDefinitionContext_1 = require("./useResourceDefinitionContext");
/**
 * Get the definition of the all resources
 *
 * @example
 *
 * const definitions = useResourceDefinitions();
 * console.log(definitions.posts);
 * // {
 * //   name: 'posts',
 * //   hasList: true,
 * //   hasEdit: true,
 * //   hasShow: true,
 * //   hasCreate: true,
 * //   options: {},
 * //   icon: PostIcon,
 * //   recordRepresentation: 'title',
 * // }
 */
var useResourceDefinitions = function () {
    return (0, useResourceDefinitionContext_1.useResourceDefinitionContext)().definitions;
};
exports.useResourceDefinitions = useResourceDefinitions;
//# sourceMappingURL=useResourceDefinitions.js.map