"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useWrappedSource = void 0;
var SourceContext_1 = require("./SourceContext");
/**
 * Get the source prop for a field or input by checking if a source context is available.
 * @param {string} source The original source prop
 * @returns {string} The source prop, either the original one or the one modified by the SourceContext.
 * @example
 * const MyInput = ({ source, ...props }) => {
 *   const finalSource = useWrappedSource(source);
 *   return <input name={finalSource} {...props} />;
 * };
 */
var useWrappedSource = function (source) {
    var sourceContext = (0, SourceContext_1.useSourceContext)();
    return sourceContext.getSource(source);
};
exports.useWrappedSource = useWrappedSource;
//# sourceMappingURL=useWrappedSource.js.map