"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var dataFetchActions_1 = require("./dataFetchActions");
var defaultDataProvider_1 = require("./defaultDataProvider");
var fetchMap = {
    create: dataFetchActions_1.CREATE,
    delete: dataFetchActions_1.DELETE,
    deleteMany: dataFetchActions_1.DELETE_MANY,
    getList: dataFetchActions_1.GET_LIST,
    getMany: dataFetchActions_1.GET_MANY,
    getManyReference: dataFetchActions_1.GET_MANY_REFERENCE,
    getOne: dataFetchActions_1.GET_ONE,
    update: dataFetchActions_1.UPDATE,
    updateMany: dataFetchActions_1.UPDATE_MANY,
};
/**
 * Turn a function-based dataProvider to an object-based one
 *
 * Allows using legacy dataProviders transparently.
 *
 * @param {Function} legacyDataProvider A legacy dataProvider (type, resource, params) => Promise<any>
 *
 * @returns {Object} A dataProvider that react-admin can use
 */
var convertLegacyDataProvider = function (legacyDataProvider) {
    var proxy = new Proxy(defaultDataProvider_1.defaultDataProvider, {
        get: function (_, name) {
            return function (resource, params) {
                if (Object.keys(fetchMap).includes(name.toString())) {
                    var fetchType = fetchMap[name.toString()];
                    return legacyDataProvider(fetchType, resource, params);
                }
                return legacyDataProvider(name.toString(), resource, params);
            };
        },
        apply: function (_, __, args) {
            return legacyDataProvider.apply(legacyDataProvider, args);
        },
    });
    return proxy;
};
exports.default = convertLegacyDataProvider;
//# sourceMappingURL=convertLegacyDataProvider.js.map