"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useCreate = void 0;
var react_1 = require("react");
var react_query_1 = require("@tanstack/react-query");
var useDataProvider_1 = require("./useDataProvider");
var util_1 = require("../util");
/**
 * Get a callback to call the dataProvider.create() method, the result and the loading state.
 *
 * @param {string} resource
 * @param {Params} params The create parameters { data }
 * @param {Object} options Options object to pass to the queryClient.
 * May include side effects to be executed upon success or failure, e.g. { onSuccess: () => { refresh(); } }
 *
 * @typedef Params
 * @prop params.data The record to create, e.g. { title: 'hello, world' }
 *
 * @returns The current mutation state. Destructure as [create, { data, error, isPending }].
 *
 * The return value updates according to the request state:
 *
 * - initial: [create, { isPending: false, isIdle: true }]
 * - start:   [create, { isPending: true }]
 * - success: [create, { data: [data from response], isPending: false, isSuccess: true }]
 * - error:   [create, { error: [error from response], isPending: false, isError: true }]
 *
 * The create() function must be called with a resource and a parameter object: create(resource, { data, meta }, options)
 *
 * This hook uses react-query useMutation under the hood.
 * This means the state object contains mutate, isIdle, reset and other react-query methods.
 *
 * @see https://tanstack.com/query/v5/docs/react/reference/useMutation
 *
 * @example // set params when calling the create callback
 *
 * import { useCreate, useRecordContext } from 'react-admin';
 *
 * const LikeButton = () => {
 *     const record = useRecordContext();
 *     const like = { postId: record.id };
 *     const [create, { isPending, error }] = useCreate();
 *     const handleClick = () => {
 *         create('likes', { data: like })
 *     }
 *     if (error) { return <p>ERROR</p>; }
 *     return <button disabled={isPending} onClick={handleClick}>Like</button>;
 * };
 *
 * @example // set params when calling the hook
 *
 * import { useCreate, useRecordContext } from 'react-admin';
 *
 * const LikeButton = () => {
 *     const record = useRecordContext();
 *     const like = { postId: record.id };
 *     const [create, { isPending, error }] = useCreate('likes', { data: like });
 *     if (error) { return <p>ERROR</p>; }
 *     return <button disabled={isPending} onClick={() => create()}>Like</button>;
 * };
 *
 * @example // TypeScript
 * const [create, { data }] = useCreate<Product>('products', { data: product });
 *                    \-- data is Product
 */
var useCreate = function (resource, params, options) {
    if (params === void 0) { params = {}; }
    if (options === void 0) { options = {}; }
    var dataProvider = (0, useDataProvider_1.useDataProvider)();
    var queryClient = (0, react_query_1.useQueryClient)();
    var paramsRef = (0, react_1.useRef)(params);
    var hasCallTimeOnError = (0, react_1.useRef)(false);
    var hasCallTimeOnSuccess = (0, react_1.useRef)(false);
    var hasCallTimeOnSettled = (0, react_1.useRef)(false);
    var getMutateWithMiddlewares = options.getMutateWithMiddlewares, mutationOptions = __rest(options, ["getMutateWithMiddlewares"]);
    var mutation = (0, react_query_1.useMutation)(__assign(__assign({ mutationFn: function (_a) {
            var _b = _a === void 0 ? {} : _a, _c = _b.resource, callTimeResource = _c === void 0 ? resource : _c, _d = _b.data, callTimeData = _d === void 0 ? paramsRef.current.data : _d, _e = _b.meta, callTimeMeta = _e === void 0 ? paramsRef.current.meta : _e;
            if (!callTimeResource) {
                throw new Error('useCreate mutation requires a non-empty resource');
            }
            if (!callTimeData) {
                throw new Error('useCreate mutation requires a non-empty data object');
            }
            if (getMutateWithMiddlewares) {
                var createWithMiddlewares = getMutateWithMiddlewares(dataProvider.create.bind(dataProvider));
                return createWithMiddlewares(callTimeResource, {
                    data: callTimeData,
                    meta: callTimeMeta,
                }).then(function (_a) {
                    var data = _a.data;
                    return data;
                });
            }
            return dataProvider
                .create(callTimeResource, {
                data: callTimeData,
                meta: callTimeMeta,
            })
                .then(function (_a) {
                var data = _a.data;
                return data;
            });
        } }, mutationOptions), { onError: function (error, variables, context) {
            if (options.onError && !hasCallTimeOnError.current) {
                return options.onError(error, variables, context);
            }
        }, onSuccess: function (data, variables, context) {
            if (variables === void 0) { variables = {}; }
            var _a = variables.resource, callTimeResource = _a === void 0 ? resource : _a;
            queryClient.setQueryData([callTimeResource, 'getOne', { id: String(data.id) }], data);
            queryClient.invalidateQueries({
                queryKey: [callTimeResource, 'getList'],
            });
            queryClient.invalidateQueries({
                queryKey: [callTimeResource, 'getInfiniteList'],
            });
            queryClient.invalidateQueries({
                queryKey: [callTimeResource, 'getMany'],
            });
            queryClient.invalidateQueries({
                queryKey: [callTimeResource, 'getManyReference'],
            });
            if (options.onSuccess && !hasCallTimeOnSuccess.current) {
                options.onSuccess(data, variables, context);
            }
        }, onSettled: function (data, error, variables, context) {
            if (options.onSettled && !hasCallTimeOnSettled.current) {
                return options.onSettled(data, error, variables, context);
            }
        } }));
    var create = function (callTimeResource, callTimeParams, callTimeOptions) {
        if (callTimeResource === void 0) { callTimeResource = resource; }
        if (callTimeParams === void 0) { callTimeParams = {}; }
        if (callTimeOptions === void 0) { callTimeOptions = {}; }
        var _a = callTimeOptions.returnPromise, returnPromise = _a === void 0 ? options.returnPromise : _a, otherCallTimeOptions = __rest(callTimeOptions, ["returnPromise"]);
        hasCallTimeOnError.current = !!otherCallTimeOptions.onError;
        hasCallTimeOnSuccess.current = !!otherCallTimeOptions.onSuccess;
        hasCallTimeOnSettled.current = !!otherCallTimeOptions.onSettled;
        if (returnPromise) {
            return mutation.mutateAsync(__assign({ resource: callTimeResource }, callTimeParams), otherCallTimeOptions);
        }
        return mutation.mutate(__assign({ resource: callTimeResource }, callTimeParams), otherCallTimeOptions);
    };
    var mutationResult = (0, react_1.useMemo)(function () { return (__assign({ isLoading: mutation.isPending }, mutation)); }, [mutation]);
    return [(0, util_1.useEvent)(create), mutationResult];
};
exports.useCreate = useCreate;
//# sourceMappingURL=useCreate.js.map