"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useDelete = void 0;
var react_1 = require("react");
var react_query_1 = require("@tanstack/react-query");
var useDataProvider_1 = require("./useDataProvider");
var undoableEventEmitter_1 = __importDefault(require("./undoableEventEmitter"));
var util_1 = require("../util");
/**
 * Get a callback to call the dataProvider.delete() method, the result and the loading state.
 *
 * @param {string} resource
 * @param {Params} params The delete parameters { id, previousData }
 * @param {Object} options Options object to pass to the queryClient.
 * May include side effects to be executed upon success or failure, e.g. { onSuccess: () => { refresh(); } }
 * May include a mutation mode (optimistic/pessimistic/undoable), e.g. { mutationMode: 'undoable' }
 *
 * @typedef Params
 * @prop params.id The resource identifier, e.g. 123
 * @prop params.previousData The record before the update is applied
 *
 * @returns The current mutation state. Destructure as [deleteOne, { data, error, isPending }].
 *
 * The return value updates according to the request state:
 *
 * - initial: [deleteOne, { isPending: false, isIdle: true }]
 * - start:   [deleteOne, { isPending: true }]
 * - success: [deleteOne, { data: [data from response], isPending: false, isSuccess: true }]
 * - error:   [deleteOne, { error: [error from response], isPending: false, isError: true }]
 *
 * The deleteOne() function must be called with a resource and a parameter object: deleteOne(resource, { id, previousData, meta }, options)
 *
 * This hook uses react-query useMutation under the hood.
 * This means the state object contains mutate, isIdle, reset and other react-query methods.
 *
 * @see https://tanstack.com/query/v5/docs/react/reference/useMutation
 *
 * @example // set params when calling the deleteOne callback
 *
 * import { useDelete, useRecordContext } from 'react-admin';
 *
 * const DeleteButton = () => {
 *     const record = useRecordContext();
 *     const [deleteOne, { isPending, error }] = useDelete();
 *     const handleClick = () => {
 *         deleteOne('likes', { id: record.id, previousData: record })
 *     }
 *     if (error) { return <p>ERROR</p>; }
 *     return <button disabled={isPending} onClick={handleClick}>Delete</div>;
 * };
 *
 * @example // set params when calling the hook
 *
 * import { useDelete, useRecordContext } from 'react-admin';
 *
 * const DeleteButton = () => {
 *     const record = useRecordContext();
 *     const [deleteOne, { isPending, error }] = useDelete('likes', { id: record.id, previousData: record });
 *     if (error) { return <p>ERROR</p>; }
 *     return <button disabled={isPending} onClick={() => deleteOne()}>Delete</button>;
 * };
 *
 * @example // TypeScript
 * const [delete, { data }] = useDelete<Product>('products', { id, previousData: product });
 *                    \-- data is Product
 */
var useDelete = function (resource, params, options) {
    if (params === void 0) { params = {}; }
    if (options === void 0) { options = {}; }
    var dataProvider = (0, useDataProvider_1.useDataProvider)();
    var queryClient = (0, react_query_1.useQueryClient)();
    var id = params.id, previousData = params.previousData;
    var _a = options.mutationMode, mutationMode = _a === void 0 ? 'pessimistic' : _a, mutationOptions = __rest(options, ["mutationMode"]);
    var mode = (0, react_1.useRef)(mutationMode);
    var paramsRef = (0, react_1.useRef)(params);
    var snapshot = (0, react_1.useRef)([]);
    var hasCallTimeOnError = (0, react_1.useRef)(false);
    var hasCallTimeOnSuccess = (0, react_1.useRef)(false);
    var hasCallTimeOnSettled = (0, react_1.useRef)(false);
    var updateCache = function (_a) {
        var resource = _a.resource, id = _a.id;
        // hack: only way to tell react-query not to fetch this query for the next 5 seconds
        // because setQueryData doesn't accept a stale time option
        var now = Date.now();
        var updatedAt = mode.current === 'undoable' ? now + 5 * 1000 : now;
        var updateColl = function (old) {
            if (!old)
                return old;
            var index = old.findIndex(
            // eslint-disable-next-line eqeqeq
            function (record) { return record.id == id; });
            if (index === -1) {
                return old;
            }
            return __spreadArray(__spreadArray([], old.slice(0, index), true), old.slice(index + 1), true);
        };
        queryClient.setQueriesData({ queryKey: [resource, 'getList'] }, function (res) {
            if (!res || !res.data)
                return res;
            var newCollection = updateColl(res.data);
            var recordWasFound = newCollection.length < res.data.length;
            return recordWasFound
                ? {
                    data: newCollection,
                    total: res.total ? res.total - 1 : undefined,
                    pageInfo: res.pageInfo,
                }
                : res;
        }, { updatedAt: updatedAt });
        queryClient.setQueriesData({ queryKey: [resource, 'getInfiniteList'] }, function (res) {
            if (!res || !res.pages)
                return res;
            return __assign(__assign({}, res), { pages: res.pages.map(function (page) {
                    var newCollection = updateColl(page.data);
                    var recordWasFound = newCollection.length < page.data.length;
                    return recordWasFound
                        ? __assign(__assign({}, page), { data: newCollection, total: page.total
                                ? page.total - 1
                                : undefined, pageInfo: page.pageInfo }) : page;
                }) });
        }, { updatedAt: updatedAt });
        queryClient.setQueriesData({ queryKey: [resource, 'getMany'] }, function (coll) {
            return coll && coll.length > 0 ? updateColl(coll) : coll;
        }, { updatedAt: updatedAt });
        queryClient.setQueriesData({ queryKey: [resource, 'getManyReference'] }, function (res) {
            if (!res || !res.data)
                return res;
            var newCollection = updateColl(res.data);
            var recordWasFound = newCollection.length < res.data.length;
            return recordWasFound
                ? {
                    data: newCollection,
                    total: res.total - 1,
                }
                : res;
        }, { updatedAt: updatedAt });
    };
    var mutation = (0, react_query_1.useMutation)(__assign(__assign({ mutationFn: function (_a) {
            var _b = _a === void 0 ? {} : _a, _c = _b.resource, callTimeResource = _c === void 0 ? resource : _c, _d = _b.id, callTimeId = _d === void 0 ? paramsRef.current.id : _d, _e = _b.previousData, callTimePreviousData = _e === void 0 ? paramsRef.current.previousData : _e, _f = _b.meta, callTimeMeta = _f === void 0 ? paramsRef.current.meta : _f;
            if (!callTimeResource) {
                throw new Error('useDelete mutation requires a non-empty resource');
            }
            if (callTimeId == null) {
                throw new Error('useDelete mutation requires a non-empty id');
            }
            return dataProvider
                .delete(callTimeResource, {
                id: callTimeId,
                previousData: callTimePreviousData,
                meta: callTimeMeta,
            })
                .then(function (_a) {
                var data = _a.data;
                return data;
            });
        } }, mutationOptions), { onMutate: function (variables) { return __awaiter(void 0, void 0, void 0, function () {
            var userContext;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!mutationOptions.onMutate) return [3 /*break*/, 2];
                        return [4 /*yield*/, mutationOptions.onMutate(variables)];
                    case 1:
                        userContext = (_a.sent()) || {};
                        return [2 /*return*/, __assign({ snapshot: snapshot.current }, userContext)];
                    case 2: 
                    // Return a context object with the snapshot value
                    return [2 /*return*/, { snapshot: snapshot.current }];
                }
            });
        }); }, onError: function (error, variables, context) {
            if (variables === void 0) { variables = {}; }
            if (mode.current === 'optimistic' || mode.current === 'undoable') {
                // If the mutation fails, use the context returned from onMutate to rollback
                context.snapshot.forEach(function (_a) {
                    var key = _a[0], value = _a[1];
                    queryClient.setQueryData(key, value);
                });
            }
            if (mutationOptions.onError && !hasCallTimeOnError.current) {
                return mutationOptions.onError(error, variables, context);
            }
            // call-time error callback is executed by react-query
        }, onSuccess: function (data, variables, context) {
            if (variables === void 0) { variables = {}; }
            if (mode.current === 'pessimistic') {
                // update the getOne and getList query cache with the new result
                var _a = variables.resource, callTimeResource = _a === void 0 ? resource : _a, _b = variables.id, callTimeId = _b === void 0 ? id : _b;
                updateCache({
                    resource: callTimeResource,
                    id: callTimeId,
                });
                if (mutationOptions.onSuccess &&
                    !hasCallTimeOnSuccess.current) {
                    mutationOptions.onSuccess(data, variables, context);
                }
                // call-time success callback is executed by react-query
            }
        }, onSettled: function (data, error, variables, context) {
            if (variables === void 0) { variables = {}; }
            if (mode.current === 'optimistic' || mode.current === 'undoable') {
                // Always refetch after error or success:
                context.snapshot.forEach(function (_a) {
                    var queryKey = _a[0];
                    queryClient.invalidateQueries({ queryKey: queryKey });
                });
            }
            if (mutationOptions.onSettled && !hasCallTimeOnSettled.current) {
                return mutationOptions.onSettled(data, error, variables, context);
            }
        } }));
    var mutate = function (callTimeResource, callTimeParams, callTimeOptions) {
        if (callTimeResource === void 0) { callTimeResource = resource; }
        if (callTimeParams === void 0) { callTimeParams = {}; }
        if (callTimeOptions === void 0) { callTimeOptions = {}; }
        return __awaiter(void 0, void 0, void 0, function () {
            var mutationMode, otherCallTimeOptions, _a, callTimeId, _b, callTimePreviousData, queryKeys;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        mutationMode = callTimeOptions.mutationMode, otherCallTimeOptions = __rest(callTimeOptions, ["mutationMode"]);
                        hasCallTimeOnError.current = !!callTimeOptions.onError;
                        hasCallTimeOnSuccess.current = !!callTimeOptions.onSuccess;
                        hasCallTimeOnSettled.current = !!callTimeOptions.onSettled;
                        // store the hook time params *at the moment of the call*
                        // because they may change afterwards, which would break the undoable mode
                        // as the previousData would be overwritten by the optimistic update
                        paramsRef.current = params;
                        if (mutationMode) {
                            mode.current = mutationMode;
                        }
                        if (mode.current === 'pessimistic') {
                            return [2 /*return*/, mutation.mutate(__assign({ resource: callTimeResource }, callTimeParams), otherCallTimeOptions)];
                        }
                        _a = callTimeParams.id, callTimeId = _a === void 0 ? id : _a, _b = callTimeParams.previousData, callTimePreviousData = _b === void 0 ? previousData : _b;
                        queryKeys = [
                            [callTimeResource, 'getList'],
                            [callTimeResource, 'getInfiniteList'],
                            [callTimeResource, 'getMany'],
                            [callTimeResource, 'getManyReference'],
                        ];
                        /**
                         * Snapshot the previous values via queryClient.getQueriesData()
                         *
                         * The snapshotData ref will contain an array of tuples [query key, associated data]
                         *
                         * @example
                         * [
                         *   [['posts', 'getList'], { data: [{ id: 1, title: 'Hello' }], total: 1 }],
                         *   [['posts', 'getMany'], [{ id: 1, title: 'Hello' }]],
                         * ]
                         *
                         * @see https://tanstack.com/query/v5/docs/react/reference/QueryClient#queryclientgetqueriesdata
                         */
                        snapshot.current = queryKeys.reduce(function (prev, queryKey) {
                            return prev.concat(queryClient.getQueriesData({ queryKey: queryKey }));
                        }, []);
                        // Cancel any outgoing re-fetches (so they don't overwrite our optimistic update)
                        return [4 /*yield*/, Promise.all(snapshot.current.map(function (_a) {
                                var queryKey = _a[0];
                                return queryClient.cancelQueries({ queryKey: queryKey });
                            }))];
                    case 1:
                        // Cancel any outgoing re-fetches (so they don't overwrite our optimistic update)
                        _c.sent();
                        // Optimistically update to the new value
                        updateCache({
                            resource: callTimeResource,
                            id: callTimeId,
                        });
                        // run the success callbacks during the next tick
                        setTimeout(function () {
                            if (callTimeOptions.onSuccess) {
                                callTimeOptions.onSuccess(callTimePreviousData, __assign({ resource: callTimeResource }, callTimeParams), { snapshot: snapshot.current });
                            }
                            else if (mutationOptions.onSuccess) {
                                mutationOptions.onSuccess(callTimePreviousData, __assign({ resource: callTimeResource }, callTimeParams), { snapshot: snapshot.current });
                            }
                        }, 0);
                        if (mode.current === 'optimistic') {
                            // call the mutate method without success side effects
                            return [2 /*return*/, mutation.mutate(__assign({ resource: callTimeResource }, callTimeParams), {
                                    onSettled: callTimeOptions.onSettled,
                                    onError: callTimeOptions.onError,
                                })];
                        }
                        else {
                            // undoable mutation: register the mutation for later
                            undoableEventEmitter_1.default.once('end', function (_a) {
                                var isUndo = _a.isUndo;
                                if (isUndo) {
                                    // rollback
                                    snapshot.current.forEach(function (_a) {
                                        var key = _a[0], value = _a[1];
                                        queryClient.setQueryData(key, value);
                                    });
                                }
                                else {
                                    // call the mutate method without success side effects
                                    mutation.mutate(__assign({ resource: callTimeResource }, callTimeParams), {
                                        onSettled: callTimeOptions.onSettled,
                                        onError: callTimeOptions.onError,
                                    });
                                }
                            });
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    var mutationResult = (0, react_1.useMemo)(function () { return (__assign({ isLoading: mutation.isPending }, mutation)); }, [mutation]);
    return [(0, util_1.useEvent)(mutate), mutationResult];
};
exports.useDelete = useDelete;
//# sourceMappingURL=useDelete.js.map