import { Identifier } from '../types';
/**
 * Helper hook to get the current `recordId`.
 *
 * `recordId` is obtained from parameters if passed as a parameter, or from the `RecordContext` if there is one, or, lastly, from the react-router URL.
 *
 * @param {any} recordId optional if used inside a RecordContextProvider or if recordId can be guessed from the URL
 *
 * @returns The `recordId` determined in this manner.
 *
 * @example
 * const recordId = useGetRecordId();
 */
export declare function useGetRecordId(recordId?: Identifier): Identifier;
//# sourceMappingURL=useGetRecordId.d.ts.map