"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useGetRecordId = void 0;
var react_router_dom_1 = require("react-router-dom");
var controller_1 = require("../controller");
/**
 * Helper hook to get the current `recordId`.
 *
 * `recordId` is obtained from parameters if passed as a parameter, or from the `RecordContext` if there is one, or, lastly, from the react-router URL.
 *
 * @param {any} recordId optional if used inside a RecordContextProvider or if recordId can be guessed from the URL
 *
 * @returns The `recordId` determined in this manner.
 *
 * @example
 * const recordId = useGetRecordId();
 */
function useGetRecordId(recordId) {
    var _a;
    var contextRecord = (0, controller_1.useRecordContext)();
    var routeId = (0, react_router_dom_1.useParams)().id;
    var actualRecordId = (_a = recordId !== null && recordId !== void 0 ? recordId : contextRecord === null || contextRecord === void 0 ? void 0 : contextRecord.id) !== null && _a !== void 0 ? _a : routeId;
    if (actualRecordId == null)
        throw new Error("useGetRecordId could not find the current record id. You need to use it inside a RecordContextProvider, or inside a supported route, or provide the record id to the hook yourself.");
    return actualRecordId;
}
exports.useGetRecordId = useGetRecordId;
//# sourceMappingURL=useGetRecordId.js.map