"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchRelatedRecords = void 0;
var getRelatedIds_1 = require("./getRelatedIds");
/**
 * Helper function for calling the dataProvider.getMany() method,
 * and getting a Promise for the records indexed by id in return.
 *
 * @example
 *     fetchRelatedRecords(dataProvider)(records, 'post_id', 'posts').then(posts =>
 *         posts.map(record => ({
 *             ...record,
 *             post_title: posts[record.post_id].title,
 *         }))
 *     );
 */
var fetchRelatedRecords = function (dataProvider) {
    return function (data, field, resource) {
        return dataProvider
            .getMany(resource, { ids: (0, getRelatedIds_1.getRelatedIds)(data, field) })
            .then(function (_a) {
            var data = _a.data;
            return data.reduce(function (acc, post) {
                acc[post.id] = post;
                return acc;
            }, {});
        });
    };
};
exports.fetchRelatedRecords = fetchRelatedRecords;
//# sourceMappingURL=fetchRelatedRecords.js.map