"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormDataConsumerView = void 0;
var React = __importStar(require("react"));
var react_hook_form_1 = require("react-hook-form");
var get_1 = __importDefault(require("lodash/get"));
var useFormValues_1 = require("./useFormValues");
var core_1 = require("../core");
/**
 * Get the current (edited) value of the record from the form and pass it
 * to a child function
 *
 * @example
 *
 * const PostEdit = () => (
 *     <Edit>
 *         <SimpleForm<FieldValues>>
 *             <BooleanInput source="hasEmail" />
 *             <FormDataConsumer>
 *                 {({ formData }) => formData.hasEmail &&
 *                      <TextInput source="email" />
 *                 }
 *             </FormDataConsumer>
 *         </SimpleForm>
 *     </Edit>
 * );
 *
 * @example
 *
 * const OrderEdit = () => (
 *     <Edit>
 *         <SimpleForm>
 *             <SelectInput source="country" choices={countries} />
 *             <FormDataConsumer<FieldValues>>
 *                 {({ formData }) =>
 *                      <SelectInput
 *                          source="city"
 *                          choices={getCitiesFor(formData.country)}
 *                      />
 *                 }
 *             </FormDataConsumer>
 *         </SimpleForm>
 *     </Edit>
 * );
 */
var FormDataConsumer = function (props) {
    var form = (0, react_hook_form_1.useFormContext)();
    var 
    // Don't know exactly why, but this is needed for the form values to be updated
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    isDirty = form.formState.isDirty;
    var formData = (0, useFormValues_1.useFormValues)();
    return (React.createElement(exports.FormDataConsumerView, __assign({ formData: formData }, props)));
};
var FormDataConsumerView = function (props) {
    var children = props.children, formData = props.formData, source = props.source;
    var ret;
    var finalSource = (0, core_1.useWrappedSource)(source || '');
    // Passes an empty string here as we don't have the children sources and we just want to know if we are in an iterator
    var matches = ArraySourceRegex.exec(finalSource);
    // If we have an index, we are in an iterator like component (such as the SimpleFormIterator)
    if (matches) {
        var scopedFormData = (0, get_1.default)(formData, matches[0]);
        ret = children({ formData: formData, scopedFormData: scopedFormData });
    }
    else {
        ret = children({ formData: formData });
    }
    return ret === undefined ? null : ret;
};
exports.FormDataConsumerView = FormDataConsumerView;
exports.default = FormDataConsumer;
var ArraySourceRegex = new RegExp(/.+\.\d+$/);
//# sourceMappingURL=FormDataConsumer.js.map