"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormGroupsProvider = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var FormGroupsContext_1 = require("./FormGroupsContext");
/**
 * This component provides functions through context to manage form groups,
 * allowing to link or unlink an input to a group.
 * @see FormGroupContextProvider
 * @see useFormGroup
 * @see useFormGroups
 */
var FormGroupsProvider = function (_a) {
    var children = _a.children;
    var formGroups = (0, react_1.useRef)({});
    var subscribers = (0, react_1.useRef)({});
    var formContextValue = (0, react_1.useMemo)(function () { return ({
        /**
         * Register a subscriber function for the specified group. The subscriber
         * will be called whenever the group content changes (fields added or removed).
         */
        subscribe: function (group, subscriber) {
            if (!subscribers.current[group]) {
                subscribers.current[group] = [];
            }
            subscribers.current[group].push(subscriber);
            return function () {
                subscribers.current[group] = subscribers.current[group].filter(function (s) { return s !== subscriber; });
            };
        },
        getGroupFields: function (name) { return formGroups.current[name] || []; },
        registerGroup: function (name) {
            formGroups.current[name] = formGroups.current[name] || [];
        },
        unregisterGroup: function (name) {
            delete formGroups[name];
        },
        registerField: function (source, group) {
            if (group != null) {
                if (!(formGroups.current[group] || []).includes(source)) {
                    formGroups.current[group] = __spreadArray(__spreadArray([], (formGroups.current[group] || []), true), [
                        source,
                    ], false);
                    // Notify subscribers that the group fields have changed
                    if (subscribers.current[group]) {
                        subscribers.current[group].forEach(function (subscriber) {
                            return subscriber();
                        });
                    }
                }
            }
        },
        unregisterField: function (source, group) {
            if (group != null) {
                if (!formGroups.current[group]) {
                    console.warn("Invalid form group ".concat(group));
                }
                else {
                    var fields = new Set(formGroups.current[group]);
                    fields.delete(source);
                    formGroups.current[group] = Array.from(fields);
                    // Notify subscribers that the group fields have changed
                    if (subscribers.current[group]) {
                        subscribers.current[group].forEach(function (subscriber) {
                            return subscriber();
                        });
                    }
                }
            }
        },
    }); }, []);
    return (React.createElement(FormGroupsContext_1.FormGroupsContext.Provider, { value: formContextValue }, children));
};
exports.FormGroupsProvider = FormGroupsProvider;
//# sourceMappingURL=FormGroupsProvider.js.map